/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class BROTComponent
implements CircuitComponent {
    private int sourceLine = 0;
    private int destinationLine = 1;
    private int lengthLine = 2;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "BROT";
        name = "BROT";
        URL uRL = ClassLoader.getSystemResource("BigBROT.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigBROTOn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorBROT.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolBROT.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        int n = this.destinationLine;
        while (n < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.deleteUser(n, this);
            ++n;
        }
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.sourceLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.destinationLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.lengthLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        Node3Dialog node3Dialog = Master.DialogNode3;
        node3Dialog.setTitle("BROT Register Setup");
        int n = this.destinationLine;
        while (n < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.deleteUser(n, this);
            ++n;
        }
        node3Dialog.setState(this.sourceLine, this.destinationLine, this.lengthLine, this);
        ((Component)node3Dialog).setVisible(true);
        this.sourceLine = node3Dialog.getValue1Line();
        this.destinationLine = node3Dialog.getValue2Line();
        this.lengthLine = node3Dialog.getResultLine();
        int n2 = this.destinationLine;
        while (n2 < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.addUser(n2, this);
            ++n2;
        }
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        BROTComponent bROTComponent = new BROTComponent();
        int n = bROTComponent.destinationLine;
        while (n < SimMemory.GetReg(bROTComponent.lengthLine)) {
            SimMemory.addUser(n, bROTComponent);
            ++n;
        }
        return bROTComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        BROTComponent bROTComponent = new BROTComponent();
        bROTComponent.sourceLine = nArray[0];
        bROTComponent.destinationLine = nArray[1];
        bROTComponent.lengthLine = nArray[2];
        int n = bROTComponent.destinationLine;
        while (n < SimMemory.GetReg(bROTComponent.lengthLine)) {
            SimMemory.addUser(n, bROTComponent);
            ++n;
        }
        return bROTComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.sourceLine + " " + this.destinationLine + " " + this.lengthLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        boolean[] blArray2;
        block8: {
            int n;
            int n2;
            int n3;
            block9: {
                this.powered = blArray[0];
                blArray2 = new boolean[3];
                if (!blArray[0]) break block8;
                n3 = SimMemory.GetReg(this.lengthLine);
                blArray2[0] = true;
                n2 = 0;
                n = 0;
                if (!blArray[1]) break block9;
                n2 = SimMemory.GetReg(this.sourceLine + n3 - 1) & 1;
                boolean bl = blArray2[1] = n2 == 1;
                if (!blArray[2]) {
                    n2 = 0;
                }
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = SimMemory.GetReg(this.sourceLine + n4);
                    if (n4 == 0) {
                        n = n2;
                        n <<= 15;
                    } else {
                        n = SimMemory.GetReg(this.sourceLine + n4 - 1);
                        n &= 1;
                        n <<= 15;
                    }
                    int n6 = n5 >> 1;
                    n6 |= n;
                    SimMemory.SetReg(this.destinationLine + n4, n6 &= 0xFFFF);
                    ++n4;
                }
                break block8;
            }
            if (blArray[1]) break block8;
            n2 = SimMemory.GetReg(this.sourceLine) >> 15;
            boolean bl = blArray2[1] = (n2 &= 1) == 1;
            if (!blArray[2]) {
                n2 = 0;
            }
            int n7 = 0;
            while (n7 < n3) {
                int n8 = SimMemory.GetReg(this.sourceLine + n7);
                if (n7 == n3 - 1) {
                    n = n2;
                } else {
                    n = SimMemory.GetReg(this.sourceLine + n7 + 1) >> 15;
                    n &= 1;
                }
                int n9 = n8 << 1;
                n9 |= n;
                SimMemory.SetReg(this.destinationLine + n7, n9 &= 0xFFFF);
                ++n7;
            }
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

