/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class CMPRComponent
implements CircuitComponent {
    private int matrixaLine = 0;
    private int pointerLine = 1;
    private int lengthLine = 2;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "CMPR";
        name = "CMPR";
        URL uRL = ClassLoader.getSystemResource("BigCMPR.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigCMPROn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorCMPR.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolCMPR.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        SimMemory.deleteUser(this.pointerLine, this);
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.matrixaLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.pointerLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.lengthLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        Node3Dialog node3Dialog = Master.DialogNode3;
        node3Dialog.setTitle("CMPR Register Setup");
        SimMemory.deleteUser(this.pointerLine, this);
        node3Dialog.setState(this.matrixaLine, this.pointerLine, this.lengthLine, this);
        ((Component)node3Dialog).setVisible(true);
        this.matrixaLine = node3Dialog.getValue1Line();
        this.pointerLine = node3Dialog.getValue2Line();
        this.lengthLine = node3Dialog.getResultLine();
        SimMemory.addUser(this.pointerLine, this);
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        CMPRComponent cMPRComponent = new CMPRComponent();
        SimMemory.addUser(cMPRComponent.pointerLine, cMPRComponent);
        return cMPRComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        CMPRComponent cMPRComponent = new CMPRComponent();
        cMPRComponent.matrixaLine = nArray[0];
        cMPRComponent.pointerLine = nArray[1];
        cMPRComponent.lengthLine = nArray[2];
        SimMemory.addUser(cMPRComponent.pointerLine, cMPRComponent);
        return cMPRComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.matrixaLine + " " + this.pointerLine + " " + this.lengthLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        this.powered = blArray[0];
        boolean[] blArray2 = new boolean[3];
        if (blArray[0]) {
            int n = SimMemory.GetReg(this.lengthLine);
            boolean bl = false;
            blArray2[0] = true;
            int n2 = 0;
            int n3 = 0;
            if (!blArray[1]) {
                n3 = SimMemory.GetReg(this.pointerLine);
                n2 = n3 / 16;
            }
            while (n2 < n) {
                int n4 = SimMemory.GetReg(this.matrixaLine + n2);
                int n5 = SimMemory.GetReg(this.pointerLine + 1 + n2);
                int n6 = n3 % 16;
                while (n3 <= n * 16 && !bl && n6 < 17) {
                    int n7 = n4 & 1 << n6;
                    int n8 = n5 & 1 << n6;
                    if (n7 != n8) {
                        blArray2[1] = true;
                        bl = true;
                        SimMemory.SetReg(this.pointerLine, n3 + 1);
                        if (n7 != 0) {
                            blArray2[2] = true;
                        }
                    }
                    ++n3;
                    ++n6;
                }
                ++n2;
            }
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

