/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class DivComponent
implements CircuitComponent {
    private int value1Line = 0;
    private int value2Line = 1;
    private int quoLine = 2;
    private int remLine = 3;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "DIV";
        name = "DIV";
        URL uRL = ClassLoader.getSystemResource("BigDiv.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigDivOn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorDiv.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolDiv.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        SimMemory.deleteUser(this.quoLine, this);
        SimMemory.deleteUser(this.remLine, this);
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.value1Line);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.value2Line);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.quoLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 4, n2 + 64);
        string = "     " + Integer.toString(this.remLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 16, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        DivDialog divDialog = Master.DialogDiv;
        SimMemory.deleteUser(this.quoLine, this);
        SimMemory.deleteUser(this.remLine, this);
        divDialog.setState(this.value1Line, this.value2Line, this.quoLine, this.remLine, this);
        ((Component)divDialog).setVisible(true);
        this.value1Line = divDialog.getValue1Line();
        this.value2Line = divDialog.getValue2Line();
        this.quoLine = divDialog.getQuoLine();
        this.remLine = divDialog.getRemLine();
        SimMemory.addUser(this.quoLine, this);
        SimMemory.addUser(this.remLine, this);
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        DivComponent divComponent = new DivComponent();
        SimMemory.addUser(divComponent.quoLine, divComponent);
        SimMemory.addUser(divComponent.remLine, divComponent);
        return divComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        DivComponent divComponent = new DivComponent();
        divComponent.value1Line = nArray[0];
        divComponent.value2Line = nArray[1];
        divComponent.quoLine = nArray[2];
        divComponent.remLine = nArray[3];
        SimMemory.addUser(divComponent.quoLine, divComponent);
        SimMemory.addUser(divComponent.remLine, divComponent);
        return divComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.value1Line + " " + this.value2Line + " " + this.quoLine + " " + this.remLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        int n = SimMemory.GetReg(this.value1Line);
        int n2 = SimMemory.GetReg(this.value2Line);
        int n3 = 0;
        int n4 = 0;
        this.powered = blArray[0];
        boolean[] blArray2 = new boolean[3];
        if (blArray[0]) {
            if (n2 == 0) {
                blArray2[2] = true;
            } else {
                n3 = n / n2;
                if (n3 > 999) {
                    blArray2[1] = true;
                } else {
                    blArray2[0] = true;
                }
                n4 = n % n2;
                if (blArray[1]) {
                    n4 = n4 * 10000 / n2;
                }
                SimMemory.SetReg(this.quoLine, n3);
                SimMemory.SetReg(this.remLine, n4);
            }
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

