/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class Elements
extends JDialog {
    private JCheckBoxMenuItem check;
    private static Hashtable hash = new Hashtable(16);
    private LinkedList tempList = new LinkedList();
    private JPanel p = new JPanel();
    private static CircuitComponent emptyComp = new EmptyComponent();
    private static CircuitComponent hshortComp = new HShortComponent();
    private static CircuitComponent nullComp = new NullComponent();
    private static CircuitComponent endrowComp = new EndRowComponent();
    private static CircuitComponent unknownComp = new UnknownComponent();

    public Elements(Frame frame, JCheckBoxMenuItem jCheckBoxMenuItem) {
        super(frame, "Component Bin");
        this.check = jCheckBoxMenuItem;
        this.p.setLayout(new BoxLayout(this.p, 1));
        hash.put(emptyComp.getName(), emptyComp);
        hash.put(hshortComp.getName(), hshortComp);
        hash.put(nullComp.getName(), nullComp);
        hash.put(endrowComp.getName(), endrowComp);
        hash.put(unknownComp.getName(), unknownComp);
        JLabel jLabel = new JLabel("Shorts");
        jLabel.setHorizontalAlignment(0);
        this.p.add(jLabel);
        this.addComponent(hshortComp);
        URL uRL = ClassLoader.getSystemResource("ToolVShort.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        DragButton dragButton = new DragButton("VSHORT", imageIcon, imageIcon.getImage());
        dragButton.setToolTipText("Vertical Short");
        this.tempList.add(dragButton);
        this.addComponentPanel();
        if (!this.open()) {
            System.err.println("Unable to read components.cfg. Using default components.");
            jLabel = new JLabel("Switches");
            jLabel.setHorizontalAlignment(0);
            this.p.add(jLabel);
            this.addComponent(new NOComponent());
            this.addComponent(new NCComponent());
            this.addComponent(new PTComponent());
            this.addComponent(new NTComponent());
            this.addComponentPanel();
            jLabel = new JLabel("Outputs");
            jLabel.setHorizontalAlignment(0);
            this.p.add(jLabel);
            this.addComponent(new OPComponent());
            this.addComponent(new TimerComponent());
            this.addComponent(new UCTRComponent());
            this.addComponent(new DCTRComponent());
            this.addComponentPanel();
            jLabel = new JLabel("Math");
            jLabel.setHorizontalAlignment(0);
            this.p.add(jLabel);
            this.addComponent(new AddComponent());
            this.addComponent(new SubComponent());
        }
        this.addComponentPanel();
        JScrollPane jScrollPane = new JScrollPane(this.p);
        this.getContentPane().add(jScrollPane);
        this.pack();
        ((Component)this).setSize(new Dimension(160, 220));
        this.setResizable(false);
    }

    public void addComponent(CircuitComponent circuitComponent) {
        hash.put(circuitComponent.getName(), circuitComponent);
        DragButton dragButton = new DragButton(circuitComponent.getName(), circuitComponent.getToolIcon(), circuitComponent.getImage());
        dragButton.setToolTipText(circuitComponent.getTip());
        this.tempList.add(dragButton);
    }

    public void addComponentPanel() {
        ListIterator listIterator = this.tempList.listIterator();
        int n = this.tempList.size();
        if (n % 2 == 1) {
            ++n;
        }
        if ((n /= 2) > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(n, 2, 4, 8));
            while (listIterator.hasNext()) {
                jPanel.add((DragButton)listIterator.next());
            }
            this.p.add(jPanel);
        }
        this.tempList.clear();
    }

    public static CircuitComponent getComponent(String string) {
        int[] nArray = new int[6];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        string = stringTokenizer.nextToken();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens() && n < 6) {
            bl = true;
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        CircuitComponent circuitComponent = (CircuitComponent)hash.get(string);
        if (circuitComponent == null) {
            circuitComponent = unknownComp;
        }
        if (bl) {
            return circuitComponent.getInstance(nArray);
        }
        return circuitComponent.getInstance();
    }

    public boolean open() {
        boolean bl;
        block11: {
            bl = false;
            URL uRL = ClassLoader.getSystemResource("components.cfg");
            if (uRL == null) break block11;
            File file = new File(uRL.getFile());
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (file.exists()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    String string = bufferedReader.readLine();
                    if (string.equals("#Ladder Logic Simulator 1.0b")) {
                        string = bufferedReader.readLine();
                        while (string != null) {
                            Object object;
                            if (string.startsWith("#")) {
                                if (string.startsWith("#LABEL")) {
                                    this.addComponentPanel();
                                    object = new JLabel(string.substring(7));
                                    ((JLabel)object).setHorizontalAlignment(0);
                                    this.p.add((Component)object);
                                }
                            } else {
                                try {
                                    Class<?> clazz = classLoader.loadClass(string);
                                    object = (CircuitComponent)clazz.newInstance();
                                    this.addComponent((CircuitComponent)object);
                                    if (Master.verbose) {
                                        System.err.println("Loaded class: " + string);
                                    }
                                    bl = true;
                                }
                                catch (Throwable throwable) {
                                    System.err.println("ERROR: Failed to initialize class: " + string);
                                }
                            }
                            string = bufferedReader.readLine();
                        }
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        this.check.setSelected(bl);
        super.setVisible(bl);
    }
}

