/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Master
extends JFrame
implements ActionListener,
WindowListener,
Pageable,
Printable,
Runnable {
    public static boolean verbose;
    public static boolean isSaved;
    public static boolean isSimActive;
    public static Master frame;
    public static JDialog toolframe;
    public static JCheckBoxMenuItem components;
    public static JCheckBoxMenuItem networks;
    public static JMenu file;
    public static JMenu simulate;
    public static LinkedListModel net;
    public static JDesktopPane desktop;
    public static NetworkList netList;
    public static Simulation simWindow;
    public static PluginRunner plugin;
    public static Hashtable pluginTable;
    public static NONCDialog DialogNONC;
    public static OutputDialog DialogOutput;
    public static TimerDialog DialogTimer;
    public static CounterDialog DialogCounter;
    public static MulDialog DialogMul;
    public static DivDialog DialogDiv;
    public static Node3Dialog DialogNode3;
    public static PrintingDialog print;
    public static final String versionString = "Ladder Logic Simulator 1.0b";
    private static JFileChooser chooser;
    private static JFrame help;
    private static Browser helpbrowser;
    private static ImageIcon icon;
    private static Properties props;
    private PrinterJob pj;

    public Master() {
        super("Ladder Logic Simulator");
        JMenuBar jMenuBar = new JMenuBar();
        file = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("New");
        file.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Open ...");
        file.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Save ...");
        file.add(jMenuItem);
        jMenuItem.addActionListener(this);
        file.addSeparator();
        jMenuItem = new JMenuItem("Print");
        file.add(jMenuItem);
        jMenuItem.addActionListener(this);
        file.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        file.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(file);
        JMenu jMenu = new JMenu("View");
        ButtonGroup buttonGroup = new ButtonGroup();
        components = new JCheckBoxMenuItem("Component Bin");
        jMenu.add(components);
        components.setSelected(true);
        components.addActionListener(this);
        networks = new JCheckBoxMenuItem("Network Manager");
        jMenu.add(networks);
        networks.setSelected(true);
        networks.addActionListener(this);
        jMenu.addSeparator();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("System Look & Feel");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Java Look & Feel");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        simulate = new JMenu("Simulate");
        jMenuItem = new JMenuItem("Standard");
        simulate.add(jMenuItem);
        jMenuItem.addActionListener(this);
        simulate.addSeparator();
        jMenuBar.add(simulate);
        JMenu jMenu2 = new JMenu("Help");
        jMenuItem = new JMenuItem("Contents");
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem("About ...");
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Exit")) {
            this.quit();
        } else if (string.equals("New")) {
            if (isSaved || this.promptSave("New")) {
                Master.clear();
                isSaved = true;
            }
        } else if (string.equals("Open ...")) {
            this.open();
        } else if (string.equals("Save ...")) {
            this.save();
        } else if (string.equals("Print")) {
            this.pj = PrinterJob.getPrinterJob();
            this.pj.setPageable(frame);
            this.pj.setJobName("Simulator printout");
            print = new PrintingDialog((Frame)frame, net.getSize());
            if (this.pj.printDialog()) {
                Thread thread = new Thread(this);
                thread.start();
                ((Component)print).setVisible(true);
            }
        } else if (string.equals("Component Bin")) {
            ((Component)toolframe).setVisible(components.getState());
        } else if (string.equals("Network Manager")) {
            netList.setVisible(networks.getState());
        } else if (string.equals("System Look & Feel")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                this.updateAllUI();
            }
            catch (Exception exception) {
                System.err.println("Error loading L&F: " + exception);
            }
        } else if (string.equals("Java Look & Feel")) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                this.updateAllUI();
            }
            catch (Exception exception) {
                System.err.println("Error loading L&F: " + exception);
            }
        } else if (string.equals("Standard")) {
            simWindow.setVisible(true);
        } else if (string.equals("Contents")) {
            helpbrowser.loadPage("..\\docs\\Index.html");
            help.show();
        } else if (string.equals("About ...")) {
            helpbrowser.loadPage("..\\docs\\about.html");
            help.show();
        } else {
            plugin.setPlugin((SimulatorPlugin)pluginTable.get(string));
            plugin.setVisible(true);
        }
    }

    private static void addPlugin(JMenu jMenu, SimulatorPlugin simulatorPlugin) {
        pluginTable.put(simulatorPlugin.getTitle(), simulatorPlugin);
        JMenuItem jMenuItem = new JMenuItem(simulatorPlugin.getTitle());
        jMenuItem.addActionListener(frame);
        jMenu.add(jMenuItem);
    }

    public static void clear() {
        SimMemory.clear();
        SimMemory.clearReg();
        simWindow.resetReg();
        SimMemory.clearUsed();
        while (net.getSize() > 0) {
            NetworkFrame networkFrame = (NetworkFrame)net.removeLast();
            try {
                networkFrame.setClosed(true);
            }
            catch (Exception exception) {
                System.err.println("Exception!");
            }
            networkFrame.dispose();
        }
    }

    public int getNumberOfPages() {
        return net.getSize() / 2 + net.getSize() % 2;
    }

    public PageFormat getPageFormat(int n) {
        return new PageFormat();
    }

    public Printable getPrintable(int n) {
        return this;
    }

    public static void loadProps() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            props.load(new FileInputStream("sim.properties"));
        }
        catch (IOException iOException) {}
        String string = props.getProperty("frameX");
        String string2 = props.getProperty("frameY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)frame).setLocation(n4, n3);
            string = props.getProperty("frameWidth");
            string2 = props.getProperty("frameHeight");
            if (string != null && string2 != null) {
                n2 = Integer.parseInt(string);
                n = Integer.parseInt(string2);
                ((Component)frame).setSize(n2, n);
            }
        }
        string = props.getProperty("helpX");
        string2 = props.getProperty("helpY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)help).setLocation(n4, n3);
            string = props.getProperty("helpWidth");
            string2 = props.getProperty("helpHeight");
            if (string != null && string2 != null) {
                n2 = Integer.parseInt(string);
                n = Integer.parseInt(string2);
                ((Component)help).setSize(n2, n);
            }
        }
        string = props.getProperty("toolframeX");
        string2 = props.getProperty("toolframeY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)toolframe).setLocation(n4, n3);
        }
        string = props.getProperty("netListX");
        string2 = props.getProperty("netListY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)netList).setLocation(n4, n3);
        }
        string = props.getProperty("simWindowX");
        string2 = props.getProperty("simWindowY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)simWindow).setLocation(n4, n3);
        }
        string = props.getProperty("DialogNONCX");
        string2 = props.getProperty("DialogNONCY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogNONC).setLocation(n4, n3);
        }
        string = props.getProperty("DialogOutputX");
        string2 = props.getProperty("DialogOutputY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogOutput).setLocation(n4, n3);
        }
        string = props.getProperty("DialogCounterX");
        string2 = props.getProperty("DialogCounterY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogCounter).setLocation(n4, n3);
        }
        string = props.getProperty("DialogTimerX");
        string2 = props.getProperty("DialogTimerY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogTimer).setLocation(n4, n3);
        }
        string = props.getProperty("DialogMulX");
        string2 = props.getProperty("DialogMulY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogMul).setLocation(n4, n3);
        }
        string = props.getProperty("DialogDivX");
        string2 = props.getProperty("DialogDivY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogDiv).setLocation(n4, n3);
        }
        string = props.getProperty("DialogNode3X");
        string2 = props.getProperty("DialogNode3Y");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)DialogNode3).setLocation(n4, n3);
        }
        string = props.getProperty("SimPluginX");
        string2 = props.getProperty("SimPluginY");
        if (string != null && string2 != null) {
            n4 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            ((Component)plugin).setLocation(n4, n3);
        }
        if ((string = props.getProperty("SimEvalDelay")) != null) {
            simWindow.setEvalDelay(Integer.parseInt(string));
        }
        if ((string = props.getProperty("SimRedrawDelay")) != null) {
            simWindow.setRedrawDelay(Integer.parseInt(string));
        }
        if ((string = props.getProperty("SimMinDelay")) != null) {
            simWindow.setMinDelay(Integer.parseInt(string));
        }
        if ((string = props.getProperty("Path")) != null) {
            chooser.setCurrentDirectory(new File(string));
        }
    }

    public static void main(String[] stringArray) {
        isSimActive = false;
        verbose = false;
        if (stringArray.length > 1) {
            verbose = true;
        }
        JWindow jWindow = new JWindow();
        URL uRL = ClassLoader.getSystemResource("splash.gif");
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        jWindow.getContentPane().add(jLabel);
        ((Component)jWindow).setSize(300, 200);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jWindow).setLocation(dimension.width / 2 - 150, dimension.height / 2 - 100);
        ((Component)jWindow).setVisible(true);
        props = new Properties();
        frame = new Master();
        frame.setDefaultCloseOperation(0);
        chooser = new JFileChooser();
        ExtensionFilter extensionFilter = new ExtensionFilter("net", "Simulator files (.net)");
        chooser.addChoosableFileFilter(extensionFilter);
        chooser.setFileFilter(extensionFilter);
        toolframe = new Elements((Frame)frame, components);
        desktop = new JDesktopPane();
        help = new JFrame("Ladder Simulator Help");
        helpbrowser = new Browser();
        help.getContentPane().add(helpbrowser);
        uRL = ClassLoader.getSystemResource("help.gif");
        icon = new ImageIcon(uRL);
        ((Frame)help).setIconImage(icon.getImage());
        uRL = ClassLoader.getSystemResource("icon.gif");
        icon = new ImageIcon(uRL);
        ((Frame)frame).setIconImage(icon.getImage());
        DialogNONC = new NONCDialog(frame);
        DialogOutput = new OutputDialog(frame);
        DialogTimer = new TimerDialog(frame);
        DialogCounter = new CounterDialog(frame);
        DialogNode3 = new Node3Dialog(frame);
        DialogMul = new MulDialog(frame);
        DialogDiv = new DivDialog(frame);
        isSaved = true;
        SimMemory.init();
        frame.addWindowListener(frame);
        ((Component)frame).setSize(600, 400);
        ((Component)frame).setLocation(150, 100);
        ((Component)toolframe).setLocation(600, 145);
        ((Component)help).setLocation(400, 150);
        help.pack();
        ((Component)help).setSize(400, 450);
        simWindow = new Simulation(frame);
        plugin = new PluginRunner(frame);
        frame.getContentPane().add(desktop);
        net = new LinkedListModel();
        netList = new NetworkList((Frame)frame, net, networks);
        Master.clear();
        ((Component)netList).setLocation(580, 295);
        Master.loadProps();
        pluginTable = new Hashtable();
        if (Master.openSimPlugins(simulate, "plugins.cfg")) {
            System.out.println("Loaded plugins successfully.");
        } else {
            System.out.println("No plugins loaded.");
        }
        frame.show();
        toolframe.show();
        netList.show();
        jWindow.dispose();
    }

    public void open() {
        block11: {
            int n;
            if (!isSaved && !this.promptSave("Open") || (n = chooser.showOpenDialog(this)) != 0) break block11;
            File file = chooser.getSelectedFile();
            boolean bl = true;
            boolean bl2 = false;
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, "File not found.", "Open failed", 0);
                bl = false;
            }
            if (bl) {
                Master.clear();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    String string = bufferedReader.readLine();
                    if (string.equals(versionString)) {
                        String string2 = bufferedReader.readLine();
                        while (string2 != null && string2.startsWith("NETWORK")) {
                            String string3;
                            int n2;
                            String string4 = string2.length() > 8 ? string2.substring(8) : "";
                            NetworkFrame networkFrame = new NetworkFrame(net.getSize(), string4);
                            int n3 = 0;
                            while (n3 < 8) {
                                n2 = 0;
                                while (n2 < 11) {
                                    string3 = bufferedReader.readLine();
                                    networkFrame.getNetwork().setNode(n3, n2, Elements.getComponent(string3));
                                    ++n2;
                                }
                                ++n3;
                            }
                            n2 = 0;
                            while (n2 < 7) {
                                string3 = bufferedReader.readLine();
                                networkFrame.getNetwork().setVShorts(n2, string3);
                                ++n2;
                            }
                            string3 = bufferedReader.readLine();
                            String string5 = new String();
                            while (!string3.equals("~ENDCOMMENT")) {
                                string5 = String.valueOf(string5) + string3 + "\n";
                                string3 = bufferedReader.readLine();
                            }
                            networkFrame.setText(string5.substring(0, string5.length() - 1));
                            net.add(networkFrame);
                            desktop.add(networkFrame);
                            networkFrame.setVisible(false);
                            string2 = bufferedReader.readLine();
                        }
                        isSaved = true;
                    } else {
                        JOptionPane.showMessageDialog(this, "Not A Simulator File.", "Open failed", 0);
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
    }

    public static boolean openSimPlugins(JMenu jMenu, String string) {
        boolean bl;
        block8: {
            URL uRL = ClassLoader.getSystemResource(string);
            File file = new File(uRL.getFile());
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            bl = false;
            if (file == null || !file.exists()) break block8;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                if (string2.equals("#Ladder Logic Simulator 1.0b")) {
                    string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        if (!string2.startsWith("#")) {
                            try {
                                Class<?> clazz = classLoader.loadClass(string2);
                                if (verbose) {
                                    System.out.println("Loaded plugin: " + string2);
                                }
                                Master.addPlugin(jMenu, (SimulatorPlugin)clazz.newInstance());
                                bl = true;
                            }
                            catch (Exception exception) {
                                System.err.println("Failed to load plugin: " + string2);
                                exception.printStackTrace();
                            }
                        }
                        string2 = bufferedReader.readLine();
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        return bl;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = n * 2;
        if (n2 > net.getSize()) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.setColor(Color.black);
        graphics.drawString("Network " + n2, 0, 12);
        NetworkFrame networkFrame = (NetworkFrame)net.get(n2);
        networkFrame.getNetwork().renderNetwork(graphics, 0, 20);
        String string = networkFrame.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n3 = 225;
        while (stringTokenizer.hasMoreElements() && n3 < 332) {
            graphics.drawString(stringTokenizer.nextToken(), 0, n3);
            n3 += 12;
        }
        if (Master.print.bar.getValue() < n2) {
            Master.print.bar.setValue(n2);
        }
        if (n2 + 1 < net.getSize()) {
            graphics.drawString("Network " + (n2 + 1), 0, 352);
            networkFrame = (NetworkFrame)net.get(n2 + 1);
            networkFrame.getNetwork().renderNetwork(graphics, 0, 364);
            string = networkFrame.getText();
            stringTokenizer = new StringTokenizer(string, "\n");
            n3 = 569;
            while (stringTokenizer.hasMoreElements() && n3 < 636) {
                graphics.drawString(stringTokenizer.nextToken(), 0, n3);
                n3 += 12;
            }
            if (Master.print.bar.getValue() < n2 + 1) {
                Master.print.bar.setValue(n2 + 1);
            }
        }
        return 0;
    }

    public boolean promptSave(String string) {
        int n = JOptionPane.showConfirmDialog(this, "The current network is unsaved. Would you like to save before proceeding?", string, 1, 2);
        if (n == 0) {
            return this.save();
        }
        return n == 1;
    }

    public void quit() {
        if (!isSaved) {
            int n = JOptionPane.showConfirmDialog(this, "Save before exiting?", "Quit", 1, 2);
            if (n == 0) {
                if (this.save()) {
                    Master.saveProps();
                    System.exit(0);
                }
            } else if (n == 1) {
                Master.saveProps();
                System.exit(0);
            }
        } else {
            int n = JOptionPane.showConfirmDialog(this, "Exit Ladder Simulator?", "Quit", 0, 3);
            if (n == 0) {
                Master.saveProps();
                System.exit(0);
            }
        }
    }

    public void run() {
        try {
            this.pj.print();
        }
        catch (PrinterException printerException) {}
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        ((Component)print).setVisible(false);
    }

    public boolean save() {
        int n = chooser.showSaveDialog(this);
        if (n == 0) {
            int n2;
            File file = chooser.getSelectedFile();
            String string = file.getPath();
            if (!string.endsWith(".net")) {
                string = String.valueOf(string) + ".net";
                file = new File(string);
            }
            boolean bl = true;
            ListIterator listIterator = net.listIterator(0);
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, "The specified file exists. Overwrite?", "Save", 0, 2)) == 1) {
                bl = false;
            }
            if (bl) {
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                    dataOutputStream.writeBytes("Ladder Logic Simulator 1.0b\n");
                    while (listIterator.hasNext()) {
                        String string2;
                        int n3;
                        NetworkFrame networkFrame = (NetworkFrame)listIterator.next();
                        dataOutputStream.writeBytes("NETWORK " + networkFrame.getName() + "\n");
                        n2 = 0;
                        while (n2 < 8) {
                            n3 = 0;
                            while (n3 < 11) {
                                string2 = networkFrame.getNetwork().getNode(n2, n3).getSaveData();
                                dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                                ++n3;
                            }
                            ++n2;
                        }
                        n3 = 0;
                        while (n3 < 7) {
                            string2 = networkFrame.getNetwork().getVShorts(n3);
                            dataOutputStream.writeBytes(String.valueOf(string2) + "\n");
                            ++n3;
                        }
                        string2 = networkFrame.getText();
                        dataOutputStream.writeBytes(String.valueOf(string2) + "\n~ENDCOMMENT\n");
                    }
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
            isSaved = true;
            return true;
        }
        return false;
    }

    public static void saveProps() {
        props.setProperty("frameX", Integer.toString(frame.getX()));
        props.setProperty("frameY", Integer.toString(frame.getY()));
        props.setProperty("frameWidth", Integer.toString(frame.getWidth()));
        props.setProperty("frameHeight", Integer.toString(frame.getHeight()));
        props.setProperty("toolframeX", Integer.toString(toolframe.getX()));
        props.setProperty("toolframeY", Integer.toString(toolframe.getY()));
        props.setProperty("netListX", Integer.toString(netList.getX()));
        props.setProperty("netListY", Integer.toString(netList.getY()));
        props.setProperty("helpX", Integer.toString(help.getX()));
        props.setProperty("helpY", Integer.toString(help.getY()));
        props.setProperty("helpWidth", Integer.toString(help.getWidth()));
        props.setProperty("helpHeight", Integer.toString(help.getHeight()));
        props.setProperty("simWindowX", Integer.toString(simWindow.getX()));
        props.setProperty("simWindowY", Integer.toString(simWindow.getY()));
        props.setProperty("DialogNONCX", Integer.toString(DialogNONC.getX()));
        props.setProperty("DialogNONCY", Integer.toString(DialogNONC.getY()));
        props.setProperty("DialogOutputX", Integer.toString(DialogOutput.getX()));
        props.setProperty("DialogOutputY", Integer.toString(DialogOutput.getY()));
        props.setProperty("DialogCounterX", Integer.toString(DialogCounter.getX()));
        props.setProperty("DialogCounterY", Integer.toString(DialogCounter.getY()));
        props.setProperty("DialogTimerX", Integer.toString(DialogTimer.getX()));
        props.setProperty("DialogTimerY", Integer.toString(DialogTimer.getY()));
        props.setProperty("DialogMulX", Integer.toString(DialogMul.getX()));
        props.setProperty("DialogMulY", Integer.toString(DialogMul.getY()));
        props.setProperty("DialogDivX", Integer.toString(DialogDiv.getX()));
        props.setProperty("DialogDivY", Integer.toString(DialogDiv.getY()));
        props.setProperty("DialogNode3X", Integer.toString(DialogNode3.getX()));
        props.setProperty("DialogNode3Y", Integer.toString(DialogNode3.getY()));
        props.setProperty("SimPluginX", Integer.toString(plugin.getX()));
        props.setProperty("SimPluginY", Integer.toString(plugin.getY()));
        props.setProperty("SimEvalDelay", Integer.toString(simWindow.getEvalDelay()));
        props.setProperty("SimRedrawDelay", Integer.toString(simWindow.getRedrawDelay()));
        props.setProperty("SimMinDelay", Integer.toString(simWindow.getMinDelay()));
        props.setProperty("Path", chooser.getCurrentDirectory().getPath());
        try {
            props.store(new FileOutputStream("sim.properties"), versionString);
        }
        catch (IOException iOException) {}
    }

    public void updateAllUI() {
        SwingUtilities.updateComponentTreeUI(this);
        SwingUtilities.updateComponentTreeUI(toolframe);
        SwingUtilities.updateComponentTreeUI(chooser);
        SwingUtilities.updateComponentTreeUI(simWindow);
        SwingUtilities.updateComponentTreeUI(netList);
        SwingUtilities.updateComponentTreeUI(DialogNONC);
        SwingUtilities.updateComponentTreeUI(DialogOutput);
        SwingUtilities.updateComponentTreeUI(DialogTimer);
        SwingUtilities.updateComponentTreeUI(DialogCounter);
        SwingUtilities.updateComponentTreeUI(print);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.quit();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

