/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class MulComponent
implements CircuitComponent {
    private int value1Line = 0;
    private int value2Line = 1;
    private int highLine = 2;
    private int lowLine = 3;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "MUL";
        name = "MUL";
        URL uRL = ClassLoader.getSystemResource("BigMul.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigMulOn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorMul.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolMul.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        SimMemory.deleteUser(this.highLine, this);
        SimMemory.deleteUser(this.lowLine, this);
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.value1Line);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.value2Line);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.highLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 4, n2 + 64);
        string = "     " + Integer.toString(this.lowLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 16, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        MulDialog mulDialog = Master.DialogMul;
        SimMemory.deleteUser(this.highLine, this);
        SimMemory.deleteUser(this.lowLine, this);
        mulDialog.setState(this.value1Line, this.value2Line, this.highLine, this.lowLine, this);
        ((Component)mulDialog).setVisible(true);
        this.value1Line = mulDialog.getValue1Line();
        this.value2Line = mulDialog.getValue2Line();
        this.highLine = mulDialog.getHighLine();
        this.lowLine = mulDialog.getLowLine();
        SimMemory.addUser(this.highLine, this);
        SimMemory.addUser(this.lowLine, this);
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        MulComponent mulComponent = new MulComponent();
        SimMemory.addUser(mulComponent.highLine, mulComponent);
        SimMemory.addUser(mulComponent.lowLine, mulComponent);
        return mulComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        MulComponent mulComponent = new MulComponent();
        mulComponent.value1Line = nArray[0];
        mulComponent.value2Line = nArray[1];
        mulComponent.highLine = nArray[2];
        mulComponent.lowLine = nArray[3];
        SimMemory.addUser(mulComponent.highLine, mulComponent);
        SimMemory.addUser(mulComponent.lowLine, mulComponent);
        return mulComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.value1Line + " " + this.value2Line + " " + this.highLine + " " + this.lowLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        int n = SimMemory.GetReg(this.value1Line);
        int n2 = SimMemory.GetReg(this.value2Line);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.powered = blArray[0];
        boolean[] blArray2 = new boolean[3];
        if (blArray[0] && n < 65535 && n > 0 && n2 < 65535 && n2 > 0) {
            n3 = n * n2;
            n4 = n3 >> 16;
            n5 = n3 & 0xFFFF;
            SimMemory.SetReg(this.highLine, n4);
            SimMemory.SetReg(this.lowLine, n5);
            blArray2[0] = true;
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

