/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class NCComponent
implements CircuitComponent {
    private int line = 1025;
    private int bit = 0;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "Norm. Closed Switch";
        name = "NC";
        URL uRL = ClassLoader.getSystemResource("ToolNC.gif");
        icon = new ImageIcon(uRL);
        pic = icon.getImage();
        uRL = ClassLoader.getSystemResource("ToolNCOn.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorNC.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
    }

    public void clear() {
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        if (this.line == 1024) {
            graphics.setFont(Network.bigFont);
            graphics.drawString("M", n + 7, n2 + 8);
            graphics.setFont(Network.myFont);
        } else if (this.line == 1025) {
            graphics.setFont(Network.bigFont);
            graphics.drawString("I", n + 7, n2 + 8);
            graphics.setFont(Network.myFont);
        } else if (this.line == 1026) {
            graphics.setFont(Network.bigFont);
            graphics.drawString("O", n + 7, n2 + 8);
            graphics.setFont(Network.myFont);
        } else if (this.line == 1027) {
            graphics.setFont(Network.bigFont);
            graphics.drawString("F", n + 7, n2 + 8);
            graphics.setFont(Network.myFont);
        } else {
            String string = "   " + this.line;
            string = string.substring(string.length() - 4);
            graphics.drawString(string, n, n2 + 7);
        }
        graphics.drawString(Integer.toString(this.bit), n + 27, n2 + 7);
        graphics.setColor(Color.black);
    }

    public void edit() {
        Master.DialogNONC.setState(this.line, this.bit);
        ((Component)Master.DialogNONC).setVisible(true);
        this.line = Master.DialogNONC.getLine();
        this.bit = Master.DialogNONC.getBit();
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        return new NCComponent();
    }

    public CircuitComponent getInstance(int[] nArray) {
        NCComponent nCComponent = new NCComponent();
        nCComponent.line = nArray[0];
        nCComponent.bit = nArray[1];
        return nCComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.line + " " + this.bit;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
        this.powered = false;
    }

    public int size() {
        return 1;
    }

    public boolean[] step(boolean[] blArray) {
        boolean[] blArray2 = new boolean[1];
        this.powered = SimMemory.GetBit(this.line, this.bit) ^ true;
        blArray2[0] = blArray[0] && this.powered;
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

