/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

class NetworkList
extends JDialog
implements ActionListener,
InternalFrameListener {
    private JCheckBoxMenuItem check;
    private LinkedListModel net;
    private final JList netList;

    public NetworkList(Frame frame, LinkedListModel linkedListModel, JCheckBoxMenuItem jCheckBoxMenuItem) {
        super(frame, "Network Manager");
        this.net = linkedListModel;
        this.check = jCheckBoxMenuItem;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.netList = new JList(this.net);
        this.netList.setPrototypeCellValue("Network 9999");
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Insert Above");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.setInvoker(this.netList);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2) {
                    NetworkFrame networkFrame;
                    int n2 = netList.locationToIndex(mouseEvent.getPoint());
                    if (n2 != -1 && (networkFrame = (NetworkFrame)net.get(n2)).isVisible()) {
                        networkFrame.setVisible(false);
                        Master.frame.repaint();
                    }
                } else if (mouseEvent.getClickCount() == 1 && (n = netList.locationToIndex(mouseEvent.getPoint())) != -1) {
                    NetworkFrame networkFrame = (NetworkFrame)net.get(n);
                    networkFrame.show();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            public void showPopup(MouseEvent mouseEvent) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.netList.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.netList);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        JButton jButton = new JButton("Close All");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        jButton = new JButton("Add Network");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jButton = new JButton("Simulate");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        jPanel.add(jPanel3);
        this.getContentPane().add(jPanel);
        this.pack();
        ((Component)this).setSize(160, 250);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.net.getSize();
        if (string.equals("Close All")) {
            int n2 = 0;
            while (n2 < this.net.getSize()) {
                ((NetworkFrame)this.net.get(n2)).setVisible(false);
                ++n2;
            }
        } else if (string.equals("Add Network")) {
            Master.isSaved = false;
            NetworkFrame networkFrame = new NetworkFrame(n, "");
            ++n;
            this.net.add(networkFrame);
            Master.desktop.add(networkFrame);
            networkFrame.show();
        } else if (string.equals("Simulate")) {
            Master.simWindow.setVisible(true);
        } else if (string.equals("Delete")) {
            int n3;
            n = this.netList.getSelectedIndex();
            if (n != -1 && (n3 = JOptionPane.showConfirmDialog(this, "Delete Network " + n + "?", "Delete", 0, 2)) == 0) {
                Master.isSaved = false;
                NetworkFrame networkFrame = (NetworkFrame)this.net.remove(n);
                try {
                    networkFrame.setClosed(true);
                }
                catch (Exception exception) {
                    System.err.println("Exception!");
                }
                networkFrame.dispose();
                if (--n < 0) {
                    n = 0;
                }
                while (n < this.net.getSize()) {
                    ((NetworkFrame)this.net.get(n)).setName(n);
                    ++n;
                }
            }
        } else if (string.equals("Insert Above")) {
            n = this.netList.getSelectedIndex();
            if (n != -1) {
                Master.isSaved = false;
                NetworkFrame networkFrame = new NetworkFrame(n, "");
                this.net.add(n, networkFrame);
                Master.desktop.add(networkFrame);
                networkFrame.show();
                while (n < this.net.getSize()) {
                    ((NetworkFrame)this.net.get(n)).setName(n);
                    ++n;
                }
            }
        } else if (string.equals("Rename") && (n = this.netList.getSelectedIndex()) != -1) {
            Master.isSaved = false;
            NetworkFrame networkFrame = (NetworkFrame)this.net.get(n);
            String string2 = (String)JOptionPane.showInputDialog(this, "Enter name for Network " + n, "Rename Network", -1, null, null, networkFrame.getName());
            if (string2 != null) {
                networkFrame.setName(string2);
            }
        }
        this.repaint();
        Master.frame.repaint();
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        NetworkFrame networkFrame = (NetworkFrame)internalFrameEvent.getSource();
        this.netList.setSelectedValue(networkFrame.getTitle(), true);
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void setVisible(boolean bl) {
        this.check.setSelected(bl);
        super.setVisible(bl);
    }
}

