/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class OPComponent
implements CircuitComponent {
    private int line = 1026;
    private int bit = 0;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "Output Coil";
        name = "OP";
        URL uRL = ClassLoader.getSystemResource("ToolOP.gif");
        icon = new ImageIcon(uRL);
        pic = icon.getImage();
        uRL = ClassLoader.getSystemResource("ToolOPOn.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorOP.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
    }

    public void clear() {
        if (this.line < 1024) {
            SimMemory.deleteUser(this.line, this);
        }
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        if (this.line == 1026) {
            graphics.setFont(Network.bigFont);
            graphics.drawString("O", n + 4, n2 + 8);
            graphics.setFont(Network.myFont);
        } else if (this.line == 1027) {
            graphics.setFont(Network.bigFont);
            graphics.drawString("F", n + 4, n2 + 8);
            graphics.setFont(Network.myFont);
        } else {
            String string = "   " + this.line;
            string = string.substring(string.length() - 4);
            graphics.drawString(string, n - 2, n2 + 7);
        }
        graphics.drawString(Integer.toString(this.bit), n + 30, n2 + 7);
        graphics.setColor(Color.black);
    }

    public void edit() {
        if (this.line < 1024) {
            SimMemory.deleteUser(this.line, this);
        }
        Master.DialogOutput.setState(this.line, this.bit, this);
        ((Component)Master.DialogOutput).setVisible(true);
        this.line = Master.DialogOutput.getLine();
        if (this.line < 1024) {
            SimMemory.addUser(this.line, this);
        }
        this.bit = Master.DialogOutput.getBit();
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        OPComponent oPComponent = new OPComponent();
        if (oPComponent.line < 1024) {
            SimMemory.addUser(oPComponent.line, oPComponent);
        }
        return oPComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        OPComponent oPComponent = new OPComponent();
        oPComponent.line = nArray[0];
        oPComponent.bit = nArray[1];
        if (oPComponent.line < 1024) {
            SimMemory.addUser(oPComponent.line, oPComponent);
        }
        return oPComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.line + " " + this.bit;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
        this.powered = false;
    }

    public int size() {
        return 1;
    }

    public boolean[] step(boolean[] blArray) {
        SimMemory.SetBit(this.line, this.bit, blArray[0]);
        this.powered = blArray[0];
        return blArray;
    }

    public boolean terminatesRung() {
        return true;
    }
}

