/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.ListIterator;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class PluginRunner
extends JDialog
implements Runnable {
    SimulatorPlugin myPlugin;
    boolean playing;
    Thread runThread;
    int evalDelay = 40;
    int minDelay = 8;
    int redrawDelay = 100;
    long startTime;
    int timeEval;
    int numEval = 0;
    ListIterator list;
    boolean stateComp;
    boolean stateNet;

    public PluginRunner(Frame frame) {
        super(frame, "Simulation");
        this.pack();
        this.setResizable(false);
    }

    public int getEvalDelay() {
        return this.evalDelay;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getRedrawDelay() {
        return this.redrawDelay;
    }

    public void run() {
        Thread thread = new Thread(){

            public void run() {
                PluginRunner.this.myPlugin.step();
            }
        };
        int n = this.evalDelay;
        if (Master.net.getSize() > 0) {
            n = this.evalDelay / Master.net.getSize() + this.minDelay;
        }
        this.numEval = 0;
        this.startTime = new Date().getTime();
        while (this.playing) {
            try {
                try {
                    SwingUtilities.invokeAndWait(thread);
                }
                catch (InvocationTargetException invocationTargetException) {}
                Master.frame.repaint(this.redrawDelay);
                do {
                    Thread.sleep(n);
                } while (!this.stepNetwork());
                if (!Master.verbose) continue;
                ++this.numEval;
                if (this.numEval < 5) continue;
                this.timeEval = (int)(new Date().getTime() - this.startTime);
                if (this.timeEval == 0) {
                    this.timeEval = 1;
                }
                System.err.println("Rate: " + 1000 * this.numEval / this.timeEval);
                this.numEval = 0;
                this.startTime = new Date().getTime();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setEvalDelay(int n) {
        this.evalDelay = n;
    }

    public void setMinDelay(int n) {
        this.minDelay = n;
    }

    public void setPlugin(SimulatorPlugin simulatorPlugin) {
        this.getContentPane().removeAll();
        this.setTitle(simulatorPlugin.getTitle());
        this.myPlugin = simulatorPlugin;
        this.getContentPane().add(simulatorPlugin);
        this.pack();
    }

    public void setRedrawDelay(int n) {
        this.redrawDelay = n;
    }

    public void setVisible(boolean bl) {
        if (Master.isSimActive != bl) {
            Master.isSimActive = bl;
            if (bl) {
                this.stateComp = Master.toolframe.isVisible();
                this.stateNet = Master.netList.isVisible();
                ((Component)Master.toolframe).setVisible(false);
                Master.netList.setVisible(false);
                Master.components.setEnabled(false);
                Master.networks.setEnabled(false);
                Master.file.setEnabled(false);
                Master.simulate.setEnabled(false);
                this.list = Master.net.listIterator(0);
                this.playing = true;
                SimMemory.clear();
                while (this.list.hasNext()) {
                    ((NetworkFrame)this.list.next()).getNetwork().reset();
                }
                this.runThread = new Thread(this);
                this.runThread.start();
                super.setVisible(true);
            } else {
                super.setVisible(false);
                this.playing = false;
                this.runThread.interrupt();
                SimMemory.clear();
                while (this.list.hasNext()) {
                    ((NetworkFrame)this.list.next()).getNetwork().reset();
                }
                Master.components.setEnabled(true);
                Master.networks.setEnabled(true);
                Master.file.setEnabled(true);
                Master.simulate.setEnabled(true);
                ((Component)Master.toolframe).setVisible(this.stateComp);
                Master.netList.setVisible(this.stateNet);
                Master.frame.repaint(this.redrawDelay);
            }
        }
    }

    public boolean stepNetwork() {
        if (Master.net.getSize() > 0) {
            if (!this.list.hasNext()) {
                this.list = Master.net.listIterator(0);
            }
            ((NetworkFrame)this.list.next()).getNetwork().simulate();
            return this.list.hasNext() ^ true;
        }
        return true;
    }
}

