/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class RtoTComponent
implements CircuitComponent {
    private int sourceLine = 0;
    private int pointerLine = 1;
    private int lengthLine = 2;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "RtoT";
        name = "RtoT";
        URL uRL = ClassLoader.getSystemResource("BigRtoT.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigRtoTOn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorRtoT.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolRtoT.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        int n = this.pointerLine;
        while (n < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.deleteUser(n, this);
            ++n;
        }
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.sourceLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.pointerLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.lengthLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        Node3Dialog node3Dialog = Master.DialogNode3;
        node3Dialog.setTitle("RtoT Register Setup");
        int n = this.pointerLine;
        while (n < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.deleteUser(n, this);
            ++n;
        }
        node3Dialog.setState(this.sourceLine, this.pointerLine, this.lengthLine, this);
        ((Component)node3Dialog).setVisible(true);
        this.sourceLine = node3Dialog.getValue1Line();
        this.pointerLine = node3Dialog.getValue2Line();
        this.lengthLine = node3Dialog.getResultLine();
        int n2 = this.pointerLine;
        while (n2 < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.addUser(n2, this);
            ++n2;
        }
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        RtoTComponent rtoTComponent = new RtoTComponent();
        int n = rtoTComponent.pointerLine;
        while (n < SimMemory.GetReg(rtoTComponent.lengthLine)) {
            SimMemory.addUser(n, rtoTComponent);
            ++n;
        }
        return rtoTComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        RtoTComponent rtoTComponent = new RtoTComponent();
        rtoTComponent.sourceLine = nArray[0];
        rtoTComponent.pointerLine = nArray[1];
        rtoTComponent.lengthLine = nArray[2];
        int n = rtoTComponent.pointerLine;
        while (n < SimMemory.GetReg(rtoTComponent.lengthLine)) {
            SimMemory.addUser(n, rtoTComponent);
            ++n;
        }
        return rtoTComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.sourceLine + " " + this.pointerLine + " " + this.lengthLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        this.powered = blArray[0];
        boolean[] blArray2 = new boolean[3];
        if (blArray[2]) {
            SimMemory.SetReg(this.pointerLine, 0);
        }
        int n = SimMemory.GetReg(this.sourceLine);
        int n2 = SimMemory.GetReg(this.pointerLine);
        int n3 = SimMemory.GetReg(this.lengthLine);
        if (blArray[0]) {
            blArray2[0] = true;
            if (n2 == n3 - 1) {
                blArray2[1] = true;
            }
            if (n2 <= n3 - 1) {
                SimMemory.SetReg(this.pointerLine + 1 + n2, n);
                if (!blArray[1] && n2 < n3 - 1) {
                    SimMemory.SetReg(this.pointerLine, n2 + 1);
                }
            }
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

