/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class SENSComponent
implements CircuitComponent {
    private int bitLocLine = 0;
    private int dataMatrixLine = 1;
    private int lengthLine = 2;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "SENS";
        name = "SENS";
        URL uRL = ClassLoader.getSystemResource("BigSENS.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigSENSOn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorSENS.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolSENS.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        SimMemory.deleteUser(this.bitLocLine, this);
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.bitLocLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.dataMatrixLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.lengthLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        Node3Dialog node3Dialog = Master.DialogNode3;
        node3Dialog.setTitle("SENS Register Setup");
        SimMemory.deleteUser(this.bitLocLine, this);
        node3Dialog.setState(this.bitLocLine, this.dataMatrixLine, this.lengthLine, this);
        ((Component)node3Dialog).setVisible(true);
        this.bitLocLine = node3Dialog.getValue1Line();
        this.dataMatrixLine = node3Dialog.getValue2Line();
        this.lengthLine = node3Dialog.getResultLine();
        SimMemory.addUser(this.bitLocLine, this);
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        SENSComponent sENSComponent = new SENSComponent();
        SimMemory.addUser(sENSComponent.bitLocLine, sENSComponent);
        return sENSComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        SENSComponent sENSComponent = new SENSComponent();
        sENSComponent.bitLocLine = nArray[0];
        sENSComponent.dataMatrixLine = nArray[1];
        sENSComponent.lengthLine = nArray[2];
        SimMemory.addUser(sENSComponent.bitLocLine, sENSComponent);
        return sENSComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.bitLocLine + " " + this.dataMatrixLine + " " + this.lengthLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        this.powered = blArray[0];
        boolean[] blArray2 = new boolean[3];
        if (blArray[0]) {
            int n;
            blArray2[0] = true;
            int n2 = SimMemory.GetReg(this.lengthLine);
            int n3 = 0;
            if (!blArray[2]) {
                n3 = SimMemory.GetReg(this.bitLocLine);
            }
            if ((n = n3 / 16) < n2) {
                int n4 = SimMemory.GetReg(this.dataMatrixLine + n);
                int n5 = n4 >> n3 % 16;
                int n6 = n5 & 1;
                if (n6 != 0) {
                    blArray2[1] = true;
                }
                if (blArray[1]) {
                    SimMemory.SetReg(this.bitLocLine, n3 + 1);
                }
            } else if (n >= n2) {
                blArray2[2] = true;
            }
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

