/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class SimMemory {
    private static boolean[] momentary;
    private static boolean[] input;
    private static boolean[] output;
    private static boolean[] flag;
    private static int[] register;
    private static LinkedList[] regUsers;
    public static final int MOMENTARY = 1024;
    public static final int INPUT = 1025;
    public static final int OUTPUT = 1026;
    public static final int FLAG = 1027;

    private SimMemory() {
    }

    public static boolean GetBit(int n, int n2) {
        switch (n) {
            case 1024: {
                return momentary[n2];
            }
            case 1025: {
                return input[n2];
            }
            case 1026: {
                return output[n2];
            }
            case 1027: {
                return flag[n2];
            }
        }
        return (register[n] >> n2 & 1) == 1;
    }

    public static int GetReg(int n) {
        return register[n];
    }

    public static void SetBit(int n, int n2, boolean bl) {
        switch (n) {
            case 1024: {
                SimMemory.momentary[n2] = bl;
                break;
            }
            case 1025: {
                SimMemory.input[n2] = bl;
                break;
            }
            case 1026: {
                SimMemory.output[n2] = bl;
                break;
            }
            case 1027: {
                SimMemory.flag[n2] = bl;
                break;
            }
            default: {
                if (bl) {
                    int n3 = n;
                    register[n3] = register[n3] | 1 << n2;
                    break;
                }
                int n4 = n;
                register[n4] = register[n4] & (0xFFFF ^ 1 << n2);
            }
        }
    }

    public static void SetReg(int n, int n2) {
        SimMemory.register[n] = n2 % 65536;
    }

    public static void addUser(int n, CircuitComponent circuitComponent) {
        if (!regUsers[n].contains(circuitComponent)) {
            regUsers[n].add(circuitComponent);
        }
    }

    public static void clear() {
        int n = 0;
        while (n < 32) {
            SimMemory.momentary[n] = false;
            SimMemory.input[n] = false;
            SimMemory.output[n] = false;
            SimMemory.flag[n] = false;
            ++n;
        }
    }

    public static void clearReg() {
        int n = 0;
        while (n < 1024) {
            SimMemory.register[n] = 0;
            ++n;
        }
    }

    public static void clearUsed() {
        int n = 0;
        while (n < 1024) {
            if (regUsers[n] == null) {
                SimMemory.regUsers[n] = new LinkedList();
            } else {
                regUsers[n].clear();
            }
            ++n;
        }
    }

    public static void deleteUser(int n, CircuitComponent circuitComponent) {
        regUsers[n].remove(circuitComponent);
    }

    public static void init() {
        momentary = new boolean[32];
        input = new boolean[32];
        output = new boolean[32];
        flag = new boolean[32];
        register = new int[1024];
        regUsers = new LinkedList[1024];
        int n = 0;
        while (n < 1024) {
            SimMemory.regUsers[n] = new LinkedList();
            ++n;
        }
    }

    public static boolean isUsedByOther(int n, CircuitComponent circuitComponent) {
        if (regUsers[n].size() == 0) {
            return false;
        }
        if (regUsers[n].size() == 1) {
            return regUsers[n].contains(circuitComponent) ^ true;
        }
        return true;
    }
}

