/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Date;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class Simulation
extends JDialog
implements ActionListener,
ItemListener,
Runnable {
    private ImageIcon SwitchOpen;
    private ImageIcon SwitchClosed;
    private ImageIcon MomentaryOpen;
    private ImageIcon MomentaryClosed;
    private ImageIcon OutputOff;
    private ImageIcon OutputOn;
    private ImageIcon VCRstop;
    private ImageIcon VCRframe;
    private ImageIcon VCRslow;
    private ImageIcon VCRplay;
    JButton stopButton;
    JButton frameButton;
    JButton slowButton;
    JButton playButton;
    ButtonModel[] inputModel = new ButtonModel[32];
    ButtonModel[] momentaryModel = new ButtonModel[8];
    JLabel[] outputLabel = new JLabel[32];
    JLabel[] flagLabel = new JLabel[32];
    JComboBox[] regCombo = new JComboBox[8];
    JLabel[] regLabel = new JLabel[8];
    JLabel status = new JLabel("Last evaluated network: 999999");
    boolean playing;
    Thread runThread;
    int evalDelay = 40;
    int minDelay = 8;
    int redrawDelay = 100;
    long startTime;
    int timeEval;
    int numEval = 0;
    ListIterator list;
    boolean stateComp;
    boolean stateNet;

    public Simulation(Frame frame) {
        super(frame, "Simulation");
        URL uRL = ClassLoader.getSystemResource("SwitchOpen.gif");
        this.SwitchOpen = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("SwitchClosed.gif");
        this.SwitchClosed = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("MomentaryOpen.gif");
        this.MomentaryOpen = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("MomentaryClosed.gif");
        this.MomentaryClosed = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("OutputOff.gif");
        this.OutputOff = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("OutputOn.gif");
        this.OutputOn = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("VCRstop.gif");
        this.VCRstop = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("VCRframe.gif");
        this.VCRframe = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("VCRslow.gif");
        this.VCRslow = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemResource("VCRplay.gif");
        this.VCRplay = new ImageIcon(uRL);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(4, 8));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input"));
        int n = 0;
        while (n < 32) {
            JCheckBox jCheckBox = new JCheckBox(Integer.toString(n), this.SwitchOpen);
            jCheckBox.setSelectedIcon(this.SwitchClosed);
            jCheckBox.setFocusPainted(false);
            jCheckBox.setHorizontalTextPosition(0);
            jCheckBox.setVerticalTextPosition(1);
            jCheckBox.setMargin(insets);
            this.inputModel[n] = jCheckBox.getModel();
            jPanel3.add(jCheckBox);
            ++n;
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 8));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Momentary"));
        int n2 = 0;
        while (n2 < 8) {
            JButton jButton = new JButton(Integer.toString(n2), this.MomentaryOpen);
            jButton.setPressedIcon(this.MomentaryClosed);
            jButton.setBorderPainted(false);
            jButton.setFocusPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setHorizontalTextPosition(0);
            jButton.setVerticalTextPosition(1);
            jButton.setMargin(insets);
            this.momentaryModel[n2] = new myToggleModel();
            jButton.setModel(this.momentaryModel[n2]);
            jPanel4.add(jButton);
            ++n2;
        }
        JPanel jPanel5 = new JPanel();
        this.stopButton = new JButton(this.VCRstop);
        this.stopButton.setToolTipText("Pause simulation");
        this.stopButton.setActionCommand("pause");
        this.stopButton.addActionListener(this);
        jPanel5.add(this.stopButton);
        this.frameButton = new JButton(this.VCRframe);
        this.frameButton.setToolTipText("Step one network");
        this.frameButton.setActionCommand("stepone");
        this.frameButton.addActionListener(this);
        jPanel5.add(this.frameButton);
        this.slowButton = new JButton(this.VCRslow);
        this.slowButton.setToolTipText("Step all networks");
        this.slowButton.setActionCommand("stepall");
        this.slowButton.addActionListener(this);
        jPanel5.add(this.slowButton);
        this.playButton = new JButton(this.VCRplay);
        this.playButton.setToolTipText("Continuous evaluation");
        this.playButton.setActionCommand("play");
        this.playButton.addActionListener(this);
        jPanel5.add(this.playButton);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(this.status);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        GridLayout gridLayout = new GridLayout(4, 8);
        gridLayout.setHgap(5);
        jPanel6.setLayout(gridLayout);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output"));
        int n3 = 0;
        while (n3 < 32) {
            this.outputLabel[n3] = new JLabel(Integer.toString(n3), this.OutputOff, 0);
            this.outputLabel[n3].setHorizontalTextPosition(0);
            this.outputLabel[n3].setVerticalTextPosition(1);
            jPanel6.add(this.outputLabel[n3]);
            ++n3;
        }
        JPanel jPanel7 = new JPanel();
        gridLayout = new GridLayout(4, 8);
        gridLayout.setHgap(5);
        jPanel7.setLayout(gridLayout);
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Flag"));
        int n4 = 0;
        while (n4 < 32) {
            this.flagLabel[n4] = new JLabel(Integer.toString(n4), this.OutputOff, 0);
            this.flagLabel[n4].setHorizontalTextPosition(0);
            this.flagLabel[n4].setVerticalTextPosition(1);
            jPanel7.add(this.flagLabel[n4]);
            ++n4;
        }
        jPanel2.add(jPanel6);
        jPanel2.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Register"));
        int n5 = 0;
        while (n5 < 8) {
            JPanel jPanel9 = new JPanel();
            this.regCombo[n5] = new JComboBox(new NumberListModel("Reg ", 1024));
            this.regCombo[n5].setSelectedIndex(n5);
            this.regLabel[n5] = new JLabel("0000 0000 0000 0000  D:00000");
            this.regCombo[n5].addItemListener(this);
            JButton jButton = new JButton("Edit");
            jButton.setMargin(insets);
            jButton.setActionCommand("C" + n5);
            jButton.addActionListener(this);
            jPanel9.add(this.regCombo[n5]);
            jPanel9.add(this.regLabel[n5]);
            jPanel9.add(jButton);
            jPanel8.add(jPanel9);
            ++n5;
        }
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        this.getContentPane().add(jPanel8);
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.charAt(0) == 'C') {
            int n = Integer.parseInt(string.substring(1));
            String string2 = (String)JOptionPane.showInputDialog(this, "Enter a new (decimal) value for register " + n, "Change register", -1, null, null, Integer.toString(SimMemory.GetReg(n)));
            if (string2 != null) {
                try {
                    int n2 = Integer.parseInt(string2);
                    SimMemory.SetReg(n, n2);
                    this.updateDisplay();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (string.equals("pause")) {
            this.playing = false;
            this.stopButton.setEnabled(false);
            this.frameButton.setEnabled(true);
            this.slowButton.setEnabled(true);
            this.playButton.setEnabled(true);
        } else if (string.equals("stepone")) {
            this.playing = false;
            this.stepNetwork();
            this.updateDisplay();
            Master.frame.repaint(this.redrawDelay);
        } else if (string.equals("stepall")) {
            this.playing = false;
            while (!this.stepNetwork()) {
            }
            this.updateDisplay();
            Master.frame.repaint(this.redrawDelay);
        } else if (string.equals("play") && !this.playing) {
            this.playing = true;
            this.stopButton.setEnabled(true);
            this.frameButton.setEnabled(false);
            this.slowButton.setEnabled(false);
            this.playButton.setEnabled(false);
            this.status.setText("Continuous Evaluation");
            this.runThread = new Thread(this);
            this.runThread.start();
        }
    }

    public int getEvalDelay() {
        return this.evalDelay;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getRedrawDelay() {
        return this.redrawDelay;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateDisplay();
    }

    public void pollInput() {
        int n = 0;
        while (n < 32) {
            SimMemory.SetBit(1025, n, this.inputModel[n].isSelected());
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            SimMemory.SetBit(1024, n2, this.momentaryModel[n2].isPressed());
            ++n2;
        }
    }

    public void resetReg() {
        int n = 0;
        while (n < 8) {
            this.regCombo[n].setSelectedIndex(n);
            ++n;
        }
    }

    public void run() {
        Thread thread = new Thread(){

            public void run() {
                Simulation.this.updateDisplay();
            }
        };
        int n = this.evalDelay;
        if (Master.net.getSize() > 0) {
            n = this.evalDelay / Master.net.getSize() + this.minDelay;
        }
        this.numEval = 0;
        this.startTime = new Date().getTime();
        while (this.playing) {
            try {
                do {
                    Thread.sleep(n);
                } while (!this.stepNetwork());
                try {
                    SwingUtilities.invokeAndWait(thread);
                }
                catch (InvocationTargetException invocationTargetException) {}
                Master.frame.repaint(this.redrawDelay);
                if (!Master.verbose) continue;
                ++this.numEval;
                if (this.numEval < 5) continue;
                this.timeEval = (int)(new Date().getTime() - this.startTime);
                if (this.timeEval == 0) {
                    this.timeEval = 1;
                }
                System.err.println("Rate: " + 1000 * this.numEval / this.timeEval);
                this.numEval = 0;
                this.startTime = new Date().getTime();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setEvalDelay(int n) {
        this.evalDelay = n;
    }

    public void setMinDelay(int n) {
        this.minDelay = n;
    }

    public void setRedrawDelay(int n) {
        this.redrawDelay = n;
    }

    public void setVisible(boolean bl) {
        if (Master.isSimActive != bl) {
            Master.isSimActive = bl;
            if (bl) {
                this.stateComp = Master.toolframe.isVisible();
                this.stateNet = Master.netList.isVisible();
                ((Component)Master.toolframe).setVisible(false);
                Master.netList.setVisible(false);
                Master.components.setEnabled(false);
                Master.networks.setEnabled(false);
                Master.file.setEnabled(false);
                Master.simulate.setEnabled(false);
                this.stopButton.setEnabled(false);
                this.frameButton.setEnabled(true);
                this.slowButton.setEnabled(true);
                this.playButton.setEnabled(true);
                this.list = Master.net.listIterator(0);
                this.playing = false;
                this.status.setText("Simulation ready.");
                SimMemory.clear();
                while (this.list.hasNext()) {
                    ((NetworkFrame)this.list.next()).getNetwork().reset();
                }
                int n = 0;
                while (n < 32) {
                    this.inputModel[n].setSelected(SimMemory.GetBit(1025, n));
                    ++n;
                }
                this.updateDisplay();
                super.setVisible(true);
            } else {
                super.setVisible(false);
                this.playing = false;
                if (this.runThread != null) {
                    this.runThread.interrupt();
                }
                SimMemory.clear();
                while (this.list.hasNext()) {
                    ((NetworkFrame)this.list.next()).getNetwork().reset();
                }
                Master.components.setEnabled(true);
                Master.networks.setEnabled(true);
                Master.file.setEnabled(true);
                Master.simulate.setEnabled(true);
                ((Component)Master.toolframe).setVisible(this.stateComp);
                Master.netList.setVisible(this.stateNet);
                Master.frame.repaint(this.redrawDelay);
            }
        }
    }

    public boolean stepNetwork() {
        if (Master.net.getSize() > 0) {
            int n;
            if (!this.list.hasNext()) {
                this.list = Master.net.listIterator(0);
            }
            if ((n = this.list.nextIndex()) == 0) {
                this.pollInput();
            }
            ((NetworkFrame)this.list.next()).getNetwork().simulate();
            if (!this.playing) {
                this.status.setText("Last evaluated: " + n);
            }
            return this.list.hasNext() ^ true;
        }
        return true;
    }

    public void updateDisplay() {
        int n = 0;
        while (n < 32) {
            this.outputLabel[n].setIcon(SimMemory.GetBit(1026, n) ? this.OutputOn : this.OutputOff);
            this.flagLabel[n].setIcon(SimMemory.GetBit(1027, n) ? this.OutputOn : this.OutputOff);
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.regCombo[n2].getSelectedIndex();
            String string = new String();
            int n4 = 0;
            while (n4 < 4) {
                int n5 = 0;
                while (n5 < 4) {
                    string = String.valueOf(string) + (SimMemory.GetBit(n3, 15 - (n4 * 4 + n5)) ? "1" : "0");
                    ++n5;
                }
                string = String.valueOf(string) + " ";
                ++n4;
            }
            String string2 = "00000" + SimMemory.GetReg(n3);
            this.regLabel[n2].setText(String.valueOf(string) + " D:" + string2.substring(string2.length() - 5));
            ++n2;
        }
    }

    public class myToggleModel
    extends JToggleButton.ToggleButtonModel {
        private boolean lastMesg = false;

        public void setArmed(boolean bl) {
            super.setArmed(bl);
            if (bl) {
                if (!this.lastMesg) {
                    this.fireActionPerformed(new ActionEvent(this, 999, "D" + this.actionCommand));
                    this.lastMesg = true;
                }
            } else if (this.lastMesg) {
                this.fireActionPerformed(new ActionEvent(this, 999, "U" + this.actionCommand));
                this.lastMesg = false;
            }
        }
    }
}

