/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;

public class TimerComponent
implements CircuitComponent {
    private int presetLine = 0;
    private int accLine = 1;
    private int presetVal = 0;
    private int accVal = 0;
    private Date startTime;
    private long timeElapsed;
    private int millisPerTick = 1000;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "Timer";
        name = "Timer";
        URL uRL = ClassLoader.getSystemResource("BigTimer.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigTimerOn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorTimer.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolTimer.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        SimMemory.deleteUser(this.presetLine, this);
        SimMemory.deleteUser(this.accLine, this);
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.startTime != null) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "";
        if (this.millisPerTick == 1000) {
            string = "1.0";
        } else if (this.millisPerTick == 100) {
            string = "0.1";
        }
        graphics.drawString(string, n + 26, n2 + 27);
        string = "     " + Integer.toString(this.presetVal);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.accVal);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        graphics.setColor(Color.black);
    }

    public void edit() {
        SimMemory.deleteUser(this.presetLine, this);
        SimMemory.deleteUser(this.accLine, this);
        Master.DialogTimer.setState(this.presetLine, this.accLine, this.presetVal, this.accVal, this.millisPerTick, this);
        ((Component)Master.DialogTimer).setVisible(true);
        this.accLine = Master.DialogTimer.getAccLine();
        this.presetLine = Master.DialogTimer.getPresetLine();
        this.presetVal = Master.DialogTimer.getPresetVal();
        this.accVal = Master.DialogTimer.getAccVal();
        this.millisPerTick = Master.DialogTimer.getMillisPerTick();
        SimMemory.addUser(this.presetLine, this);
        SimMemory.addUser(this.accLine, this);
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        TimerComponent timerComponent = new TimerComponent();
        SimMemory.addUser(timerComponent.presetLine, timerComponent);
        SimMemory.addUser(timerComponent.accLine, timerComponent);
        return timerComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        TimerComponent timerComponent = new TimerComponent();
        timerComponent.presetLine = nArray[0];
        timerComponent.accLine = nArray[1];
        timerComponent.presetVal = nArray[2];
        timerComponent.accVal = nArray[3];
        timerComponent.millisPerTick = nArray[4];
        SimMemory.addUser(timerComponent.presetLine, timerComponent);
        SimMemory.addUser(timerComponent.accLine, timerComponent);
        return timerComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.presetLine + " " + this.accLine + " " + this.presetVal + " " + this.accVal + " " + this.millisPerTick;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
        SimMemory.SetReg(this.presetLine, this.presetVal);
        SimMemory.SetReg(this.accLine, this.accVal);
        this.startTime = null;
        this.timeElapsed = this.accVal * this.millisPerTick;
    }

    public int size() {
        return 2;
    }

    public boolean[] step(boolean[] blArray) {
        Object object;
        int n = SimMemory.GetReg(this.accLine);
        int n2 = SimMemory.GetReg(this.presetLine);
        if (blArray[1]) {
            if (Master.simWindow.playing) {
                if (this.startTime != null) {
                    object = new Date();
                    this.timeElapsed += ((Date)object).getTime() - this.startTime.getTime();
                    this.startTime = object;
                } else if (blArray[0] || this.timeElapsed > 0L) {
                    this.startTime = new Date();
                }
            } else {
                this.startTime = null;
                this.timeElapsed += 100L;
            }
            n = (int)(this.timeElapsed / (long)this.millisPerTick);
            if (n > n2) {
                n = n2;
            }
        } else {
            this.startTime = null;
            this.timeElapsed = 0L;
            n = 0;
        }
        SimMemory.SetReg(this.accLine, n);
        object = new boolean[2];
        object[0] = n == n2;
        object[1] = n < n2;
        return object;
    }

    public boolean terminatesRung() {
        return false;
    }
}

