/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TimerDialog
extends JDialog
implements ActionListener {
    private JComboBox presetCombo;
    private RegisterListModel presetComboModel;
    private JTextField presetText;
    private JButton presetSet;
    private JComboBox accCombo;
    private RegisterListModel accComboModel;
    private JTextField accText;
    private JButton accSet;
    private JRadioButton rbA;
    private JRadioButton rbB;
    private ButtonGroup rbg = new ButtonGroup();
    private int millisPerTick;
    private int presetLine;
    private int accLine;
    private int presetVal;
    private int accVal;

    public TimerDialog(Frame frame) {
        super(frame, "Timer", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.rbA = new JRadioButton("1 sec");
        ButtonModel buttonModel = this.rbA.getModel();
        buttonModel.setActionCommand("1000");
        this.rbg.add(this.rbA);
        jPanel.add(this.rbA);
        this.rbB = new JRadioButton(".1 sec");
        buttonModel = this.rbB.getModel();
        buttonModel.setActionCommand("100");
        this.rbg.add(this.rbB);
        jPanel.add(this.rbB);
        jPanel2.setLayout(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Preset"));
        this.presetComboModel = new RegisterListModel("Reg ", 1024);
        this.presetCombo = new JComboBox(this.presetComboModel);
        jPanel3.add(this.presetCombo);
        this.presetText = new JTextField(8);
        jPanel3.add(this.presetText);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Accumulator"));
        this.accComboModel = new RegisterListModel("Reg ", 1024);
        this.accCombo = new JComboBox(this.accComboModel);
        jPanel4.add(this.accCombo);
        this.accText = new JTextField(8);
        jPanel4.add(this.accText);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        JPanel jPanel5 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(this);
        jPanel5.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel5.add(jButton);
        this.getContentPane().add(jPanel5);
        this.pack();
        ((Component)this).setSize(220, 180);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.updateData();
            ((Component)this).setVisible(false);
        } else if (string.equals("Cancel")) {
            ((Component)this).setVisible(false);
        }
    }

    public int getAccLine() {
        return this.accLine;
    }

    public int getAccVal() {
        return this.accVal;
    }

    public int getMillisPerTick() {
        return this.millisPerTick;
    }

    public int getPresetLine() {
        return this.presetLine;
    }

    public int getPresetVal() {
        return this.presetVal;
    }

    public void setState(int n, int n2, int n3, int n4, int n5, CircuitComponent circuitComponent) {
        this.presetComboModel.setComponent(circuitComponent);
        this.accComboModel.setComponent(circuitComponent);
        this.presetLine = n;
        this.accLine = n2;
        this.presetVal = n3;
        this.accVal = n4;
        this.millisPerTick = n5;
        this.rbg.setSelected(this.rbA.getModel(), true);
        if (n5 == 100) {
            this.rbg.setSelected(this.rbB.getModel(), true);
        }
        this.presetCombo.setSelectedIndex(this.presetLine);
        this.presetText.setText(Integer.toString(n3));
        SimMemory.SetReg(this.presetLine, this.presetVal);
        this.accCombo.setSelectedIndex(this.accLine);
        this.accText.setText(Integer.toString(n4));
        SimMemory.SetReg(this.accLine, this.accVal);
    }

    public void updateData() {
        String string = this.rbg.getSelection().getActionCommand();
        this.millisPerTick = Integer.parseInt(string);
        this.presetLine = this.presetCombo.getSelectedIndex();
        this.accLine = this.accCombo.getSelectedIndex();
        this.presetVal = Integer.parseInt(this.presetText.getText());
        this.accVal = Integer.parseInt(this.accText.getText());
        SimMemory.SetReg(this.presetLine, this.presetVal);
        SimMemory.SetReg(this.accLine, this.accVal);
    }
}

