/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class UCTRComponent
implements CircuitComponent {
    private int presetLine = 0;
    private int accLine = 1;
    private int presetVal = 0;
    private int accVal = 0;
    private boolean last;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "Up Counter";
        name = "UCTR";
        URL uRL = ClassLoader.getSystemResource("BigUCTR.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigUCTROn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorUCTR.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolUCTR.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        SimMemory.deleteUser(this.presetLine, this);
        SimMemory.deleteUser(this.accLine, this);
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.setColor(Network.darkGreen);
            graphics.drawImage(picLit, n, n2, imageObserver);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.presetVal);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.accVal);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        graphics.setColor(Color.black);
    }

    public void edit() {
        SimMemory.deleteUser(this.presetLine, this);
        SimMemory.deleteUser(this.accLine, this);
        Master.DialogCounter.setState(this.presetLine, this.accLine, this.presetVal, this.accVal, this);
        ((Component)Master.DialogCounter).setVisible(true);
        this.accLine = Master.DialogCounter.getAccLine();
        this.presetLine = Master.DialogCounter.getPresetLine();
        this.accVal = Master.DialogCounter.getAccVal();
        this.presetVal = Master.DialogCounter.getPresetVal();
        SimMemory.addUser(this.presetLine, this);
        SimMemory.addUser(this.accLine, this);
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        UCTRComponent uCTRComponent = new UCTRComponent();
        SimMemory.addUser(uCTRComponent.presetLine, uCTRComponent);
        SimMemory.addUser(uCTRComponent.accLine, uCTRComponent);
        return uCTRComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        UCTRComponent uCTRComponent = new UCTRComponent();
        uCTRComponent.presetLine = nArray[0];
        uCTRComponent.accLine = nArray[1];
        uCTRComponent.presetVal = nArray[2];
        uCTRComponent.accVal = nArray[3];
        SimMemory.addUser(uCTRComponent.presetLine, uCTRComponent);
        SimMemory.addUser(uCTRComponent.accLine, uCTRComponent);
        return uCTRComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.presetLine + " " + this.accLine + " " + this.presetVal + " " + this.accVal;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
        SimMemory.SetReg(this.presetLine, this.presetVal);
        SimMemory.SetReg(this.accLine, this.accVal);
        this.last = false;
        this.powered = false;
    }

    public int size() {
        return 2;
    }

    public boolean[] step(boolean[] blArray) {
        int n = SimMemory.GetReg(this.accLine);
        int n2 = SimMemory.GetReg(this.presetLine);
        this.powered = false;
        if (blArray[1]) {
            if (!this.last && blArray[0] && n < n2) {
                this.powered = true;
                ++n;
            }
        } else {
            n = 0;
        }
        this.last = blArray[0];
        SimMemory.SetReg(this.accLine, n);
        boolean[] blArray2 = new boolean[]{n == n2, n < n2};
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

