/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;

public class XORComponent
implements CircuitComponent {
    private int sourceLine = 0;
    private int destinationLine = 1;
    private int lengthLine = 2;
    private boolean powered;
    private static Image pic;
    private static Image picLit;
    private static Image cursorImage;
    private static ImageIcon icon;
    private static String tip;
    private static String name;

    static {
        tip = "XOR";
        name = "XOR";
        URL uRL = ClassLoader.getSystemResource("BigXOR.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        pic = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("BigXOROn.gif");
        imageIcon = new ImageIcon(uRL);
        picLit = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("CursorXOR.gif");
        imageIcon = new ImageIcon(uRL);
        cursorImage = imageIcon.getImage();
        uRL = ClassLoader.getSystemResource("ToolXOR.gif");
        icon = new ImageIcon(uRL);
    }

    public void clear() {
        int n = this.destinationLine;
        while (n < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.deleteUser(n, this);
            ++n;
        }
    }

    public void drawComponent(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
        if (Master.isSimActive && this.powered) {
            graphics.drawImage(picLit, n, n2, imageObserver);
            graphics.setColor(Network.darkGreen);
        } else {
            graphics.drawImage(pic, n, n2, imageObserver);
        }
        String string = "     " + Integer.toString(this.sourceLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 16);
        string = "     " + Integer.toString(this.destinationLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 40);
        string = "     " + Integer.toString(this.lengthLine);
        string = string.substring(string.length() - 5);
        graphics.drawString(string, n + 10, n2 + 64);
        graphics.setColor(Color.black);
    }

    public void edit() {
        Node3Dialog node3Dialog = Master.DialogNode3;
        node3Dialog.setTitle("XOR Register Setup");
        int n = this.destinationLine;
        while (n < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.deleteUser(n, this);
            ++n;
        }
        node3Dialog.setState(this.sourceLine, this.destinationLine, this.lengthLine, this);
        ((Component)node3Dialog).setVisible(true);
        this.sourceLine = node3Dialog.getValue1Line();
        this.destinationLine = node3Dialog.getValue2Line();
        this.lengthLine = node3Dialog.getResultLine();
        int n2 = this.destinationLine;
        while (n2 < SimMemory.GetReg(this.lengthLine)) {
            SimMemory.addUser(n2, this);
            ++n2;
        }
    }

    public Image getImage() {
        return cursorImage;
    }

    public CircuitComponent getInstance() {
        XORComponent xORComponent = new XORComponent();
        int n = xORComponent.destinationLine;
        while (n < SimMemory.GetReg(xORComponent.lengthLine)) {
            SimMemory.addUser(n, xORComponent);
            ++n;
        }
        return xORComponent;
    }

    public CircuitComponent getInstance(int[] nArray) {
        XORComponent xORComponent = new XORComponent();
        xORComponent.sourceLine = nArray[0];
        xORComponent.destinationLine = nArray[1];
        xORComponent.lengthLine = nArray[2];
        int n = xORComponent.destinationLine;
        while (n < SimMemory.GetReg(xORComponent.lengthLine)) {
            SimMemory.addUser(n, xORComponent);
            ++n;
        }
        return xORComponent;
    }

    public String getName() {
        return name;
    }

    public String getSaveData() {
        return String.valueOf(name) + " " + this.sourceLine + " " + this.destinationLine + " " + this.lengthLine;
    }

    public String getTip() {
        return tip;
    }

    public ImageIcon getToolIcon() {
        return icon;
    }

    public void reset() {
    }

    public int size() {
        return 3;
    }

    public boolean[] step(boolean[] blArray) {
        int n = SimMemory.GetReg(this.lengthLine);
        this.powered = blArray[0];
        boolean[] blArray2 = new boolean[3];
        if (blArray[0]) {
            blArray2[0] = true;
            int n2 = 0;
            while (n2 < n) {
                int n3 = SimMemory.GetReg(this.sourceLine + n2);
                int n4 = SimMemory.GetReg(this.destinationLine + n2);
                n4 = n3 ^ n4;
                SimMemory.SetReg(this.destinationLine + n2, n4);
                ++n2;
            }
        }
        return blArray2;
    }

    public boolean terminatesRung() {
        return false;
    }
}

