import java.awt.*;
import java.awt.event.*;
import java.lang.String.*;
import javax.swing.*;
import javax.swing.border.*;

/**  
  * Class AddDialog
  *
  * Dialog box for the 16-bit Add function. This is utilized by 
  * AddComponent as the pop up dialog in response to its 
  * <CODE>edit</CODE> method. This modal Dialog allows the user 
  * to specify two registers to use as value1 and value2.
  *
  * @author Mike Cammarano
  * @author Charlie So
  * @author Robert Marlowe
  */

public class AddDialog extends JDialog implements ActionListener {
  private JComboBox       value1Combo;
  private NumberListModel value1ComboModel;
  private JComboBox       value2Combo;
  private NumberListModel value2ComboModel;
  private JComboBox       sumCombo;
  private RegisterListModel sumComboModel;

  private int value1Line, value2Line, sumLine;

  /**
    * Construct a new instance of the dialog.
    */
  public AddDialog(Frame owner) {	
      super(owner, " Add", true);
 
    	getContentPane().setLayout(new BoxLayout(getContentPane(), 
				   BoxLayout.Y_AXIS));

      JPanel mainPane = new JPanel();

      mainPane.setLayout(new GridLayout(3, 1));	// rows, columns

      // Specify Layout for the value1 Register indication
      JPanel top = new JPanel();
      top.setLayout(new GridLayout(1,2));
      top.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
	    	"First Argument"));
      value1Combo = new JComboBox(value1ComboModel = 
		new NumberListModel("Reg ", 1024));
      top.add(value1Combo);

      // Specify Layout for the value2 Register indication
      JPanel middle = new JPanel();
      middle.setLayout(new GridLayout(1,2));
      middle.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
		"Second Argument"));
      value2Combo = new JComboBox(value2ComboModel = 
		new NumberListModel("Reg ", 1024));
      middle.add(value2Combo);

      // Specify Layout for the sum Register indication
      JPanel bottom = new JPanel();
      bottom.setLayout(new GridLayout(1,2));
      bottom.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
		"Result"));
      sumCombo = new JComboBox(sumComboModel = 
		new RegisterListModel("Reg ", 1024));
      bottom.add(sumCombo);

      mainPane.add(top);
      mainPane.add(middle);
      mainPane.add(bottom);

      getContentPane().add(mainPane);

    //  Build button panel, containing OK and Cancel buttons.				
    JPanel buttons = new JPanel();
    JButton b;
    b = new JButton("OK");
    	b.addActionListener(this);
    	buttons.add(b);
    b = new JButton("Cancel");
    	b.addActionListener(this);
    	buttons.add(b);

    getContentPane().add(buttons);
    pack();
    setSize(200, 220);	// Adjust here for Edit Pane size
    setResizable(false);
  }


  /**
    * Process events on the OK and Cancel buttons.
    *
    * @see ActionListener
    */
  public void actionPerformed (ActionEvent e) {
        String s = e.getActionCommand();
        if(s.equals("OK")) {
          updateData();
          setVisible(false);
        } 
	else if(s.equals("Cancel")) {
          setVisible(false);
        }
  }


  /**
    * Prior to showing this Dialog, the setState function is called
    * to set all of the combo box selections to correspond to the
    * current settings of the component being edited.
    *
    * @param newvalue1Line  initially selected value1 register.
    * @param newvalue2Line  initially selected value2 register.
    * @param newsumLine     initially selected sum register.
    * @param c              component this dialog will represent.
    */
  public void setState(int newValue1Line, int newValue2Line, 
		       int newSumLine, CircuitComponent c) {

    value1Line = newValue1Line;
    value1Combo.setSelectedIndex(newValue1Line);
    value2Line = newValue2Line;
    value2Combo.setSelectedIndex(newValue2Line);
    sumLine = newSumLine;
    sumCombo.setSelectedIndex(newSumLine);

    sumComboModel.setComponent(c);
  }

  /**
    * Returns the value1 register selected in this dialog.
    *
    * @return the value1 register selected in this dialog.
    */
  public int getValue1Line() {
    return value1Line;
  }

  /**
    * Returns the value2 register selected in this dialog.
    *
    * @return the value2 register selected in this dialog.
    */
  public int getValue2Line() {
    return value2Line;
  }
  
  /**
    * Returns the sum register selected in this dialog.
    *
    * @return the sum register selected in this dialog.
    */
  public int getSumLine() {
    return sumLine;
  }
  
  
  /**
    * If the user selects the OK button, this function is called to
    * capture the states of the controls and prepare all the accessor
    * methods to return the updated values. If this function is not
    * called (i.e. if the user chooses Cancel), then the accessor 
    * methods will simply return the values that were initially 
    * specified by the <CODE>setState</CODE> method.
    */
  public void updateData() {
      value1Line = value1Combo.getSelectedIndex();
      value2Line = value2Combo.getSelectedIndex();
      sumLine    = sumCombo.getSelectedIndex();
  }
}



/*  To compile and run this Class
	first  - make sure that the class's name is also the file name 
		 -- observe case
	second - at the command prompt in the working directory of the 
		 SDK compile the class.  
			EX. L:\work>N:jdk1.2.1\bin\javac *.java
		 In this case all file *.java will be linked, 
		 therefore take care that they are related or delete 
		 unneeded files.
	third  - run the Class by 
			EX. L:\WORK>N:jdk1.2.1\bin\java figure1511
		 where figure1511 is both the name of the class & file.

    For creating links to, for example, methods ...

	{@link #reset() <CODE>reset</CODE>.}
*/
		