import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
  * A <CODE>Browser</CODE> is a miniature HTML browser used for displaying
  * help documentation within the simulator.
  * <P>
  * Adapted from: Mastering Java 1.2 by John Zukowski
  *
  * @author Mike Cammarano
  * @author Charlie So
  */
public class Browser extends JPanel {
  private final JEditorPane jt;

  /**
    * Instantiates a <CODE>Browser</CODE> window, using the path
    * docs/Index.html as the initial page.
    */
  Browser() {
    setLayout (new BorderLayout (5, 5));
    jt = new JEditorPane();
    // make read-only
    jt.setEditable(false);
    loadPage("docs\\Index.html");
    // follow links
    jt.addHyperlinkListener(new HyperlinkListener () {
      public void hyperlinkUpdate(final HyperlinkEvent e) {
        if (e.getEventType() == 
            HyperlinkEvent.EventType.ACTIVATED) {
          jt.setCursor(new Cursor(Cursor.WAIT_CURSOR));
          SwingUtilities.invokeLater(new Runnable() {
            public void run() {
              // Save original
              Document doc = jt.getDocument();
              try {
                URL url = e.getURL();
                jt.setPage(url);
              } catch (IOException io) {
                JOptionPane.showMessageDialog (
                  Browser.this, "Can't follow link", 
                  "Invalid Input", 
                   JOptionPane.ERROR_MESSAGE);
                jt.setDocument (doc);
              }
              jt.setCursor(Cursor.getDefaultCursor());
            }
          });
        } else if(e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
          jt.setCursor(new Cursor(Cursor.HAND_CURSOR));
        } else if(e.getEventType() == HyperlinkEvent.EventType.EXITED) {
          jt.setCursor(Cursor.getDefaultCursor());
        }
      }
    });
    JScrollPane pane = new JScrollPane();
    pane.setBorder (
      BorderFactory.createLoweredBevelBorder());
    pane.getViewport().add(jt);
    pane.setMinimumSize(new Dimension(200, 200));
    add(pane, BorderLayout.CENTER);
  }

  /**
    * Attempts to display the specified file in the <CODE>Browser</CODE> window.
    * 
    * @param filename  The path of the file.
    */
  public void loadPage(String filename) {
    try {
      jt.setPage((new File(filename)).toURL());
    }
    catch (IOException io) {
    }
  }
}
