import java.awt.*;
import java.awt.event.*;
import java.lang.String.*;
import javax.swing.*;
import javax.swing.border.*;

/**  
  * Class DivDialog
  *
  * Dialog box for the 16-bit Divide function. This is utilized by 
  * DivComponent as the pop up dialog in response to its 
  * <CODE>edit</CODE> method. This modal Dialog allows the user 
  * to specify the four registers to use for value1, value2, 
  * quotient, and remainder.
  *
  * @author Mike Cammarano
  * @author Charlie So
  * @author Robert Marlowe
  */

public class DivDialog extends JDialog implements ActionListener {
  private JComboBox         value1Combo;
  private NumberListModel   value1ComboModel;
  private JComboBox         value2Combo;
  private NumberListModel   value2ComboModel;
  private JComboBox         quoCombo;
  private RegisterListModel quoComboModel;
  private JComboBox         remCombo;
  private RegisterListModel remComboModel;

  private int value1Line, value2Line, quoLine, remLine;

  /**
    * Construct a new instance of the dialog.
    */
  public DivDialog(Frame owner) {	
      super(owner, " DIV Register Setup", true);
 
    	getContentPane().setLayout(new BoxLayout(getContentPane(), 
				   BoxLayout.Y_AXIS));

      JPanel mainPane = new JPanel();

      mainPane.setLayout(new GridLayout(4, 1));	// rows, columns

      // Specify Layout for the value1 Register indication
      JPanel top = new JPanel();
      top.setLayout(new GridLayout(1,2));
      top.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
	    	"Numerator"));
      value1Combo = new JComboBox(value1ComboModel = 
		new NumberListModel("Reg ", 1024));
      top.add(value1Combo);

      // Specify Layout for the value2 Register indication
      JPanel middle = new JPanel();
      middle.setLayout(new GridLayout(1,2));
      middle.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
		"Denominator"));
      value2Combo = new JComboBox(value2ComboModel = 
		new NumberListModel("Reg ", 1024));
      middle.add(value2Combo);

      // Specify Layout for the quotient Register indication
      JPanel bottomQ = new JPanel();
      bottomQ.setLayout(new GridLayout(1,2));
      bottomQ.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
		"Quotient"));
      quoCombo = new JComboBox(quoComboModel = 
		new RegisterListModel("Reg ", 1024));
      bottomQ.add(quoCombo);

      // Specify Layout for the remainder Register indication
      JPanel bottomR = new JPanel();
      bottomR.setLayout(new GridLayout(1,2));
      bottomR.setBorder(BorderFactory.createTitledBorder(
            	BorderFactory.createEtchedBorder(), 
		"Remainder"));
      remCombo = new JComboBox(remComboModel = 
		new RegisterListModel("Reg ", 1024));
      bottomR.add(remCombo);

      mainPane.add(top);
      mainPane.add(middle);
      mainPane.add(bottomQ);
      mainPane.add(bottomR);

      getContentPane().add(mainPane);

    //  Build button panel, containing OK and Cancel buttons.				
    JPanel buttons = new JPanel();
    JButton b;
    b = new JButton("OK");
    	b.addActionListener(this);
    	buttons.add(b);
    b = new JButton("Cancel");
    	b.addActionListener(this);
    	buttons.add(b);

    getContentPane().add(buttons);
    pack();
    setSize(200, 280);	// Adjust here for Edit Pane size
    setResizable(false);
  }


  /**
    * Process events on the OK and Cancel buttons.
    *
    * @see ActionListener
    */
  public void actionPerformed (ActionEvent e) {
        String s = e.getActionCommand();
        if(s.equals("OK")) {
          updateData();
          setVisible(false);
        } 
	else if(s.equals("Cancel")) {
          setVisible(false);
        }
  }


  /**
    * Prior to showing this Dialog, the setState function is called
    * to set all of the combo box selections to correspond to the
    * current settings of the component being edited.
    *
    * @param newValue1Line  initially selected value1 register.
    * @param newValue2Line  initially selected value2 register.
    * @param newQuoLine     initially selected qoutient register.
    * @param newRemLine     initially selected remainder register.
    * @param c              component this dialog will represent.
    */
  public void setState(int newValue1Line, int newValue2Line, 
		       int newQuoLine, int newRemLine, 
		       CircuitComponent c) {

    value1Line = newValue1Line;
    value1Combo.setSelectedIndex(newValue1Line);
    value2Line = newValue2Line;
    value2Combo.setSelectedIndex(newValue2Line);
    quoLine = newQuoLine;
    quoCombo.setSelectedIndex(newQuoLine);
    remLine = newRemLine;
    remCombo.setSelectedIndex(newRemLine);

    quoComboModel.setComponent(c);
    remComboModel.setComponent(c);
  }

  /**
    * Returns the value1 register selected in this dialog.
    *
    * @return the value1 register selected in this dialog.
    */
  public int getValue1Line() {
    return value1Line;
  }

  /**
    * Returns the value2 register selected in this dialog.
    *
    * @return the value2 register selected in this dialog.
    */
  public int getValue2Line() {
    return value2Line;
  }
  
  /**
    * Returns the quotient register selected in this dialog.
    *
    * @return the quotient register selected in this dialog.
    */
  public int getQuoLine() {
    return quoLine;
  }
  
  /**
    * Returns the remainder register selected in this dialog.
    *
    * @return the remainder register selected in this dialog.
    */
  public int getRemLine() {
    return remLine;
  }
  
  
  /**
    * If the user selects the OK button, this function is called to
    * capture the states of the controls and prepare all the accessor
    * methods to return the updated values. If this function is not
    * called (i.e. if the user chooses Cancel), then the accessor 
    * methods will simply return the values that were initially 
    * specified by the <CODE>setState</CODE> method.
    */
  public void updateData() {
      value1Line = value1Combo.getSelectedIndex();
      value2Line = value2Combo.getSelectedIndex();
      quoLine    = quoCombo.getSelectedIndex();
      remLine    = remCombo.getSelectedIndex();
  }
}



/*  To compile and run this Class
	first  - make sure that the class's name is also the file name 
		 -- observe case
	second - at the command prompt in the working directory of the 
		 SDK compile the class.  
			EX. L:\work>N:jdk1.2.1\bin\javac *.java
		 In this case all file *.java will be linked, 
		 therefore take care that they are related or delete 
		 unneeded files.
	third  - run the Class by 
			EX. L:\WORK>N:jdk1.2.1\bin\java figure1511
		 where figure1511 is both the name of the class & file.

    For creating links to, for example, methods ...

	{@link #reset() <CODE>reset</CODE>.}
*/
		