import java.awt.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import javax.swing.*;

/**
  * A draggable label. Used for displaying components in the component bin
  * (<CODE>Elements</CODE>).
  *
  * @author Mike Cammarano
  * @author Charlie So
  */
public class DragButton extends JLabel 
	implements DragGestureListener, DragSourceListener 
{
  /**
    * The internal name associated with the circuit component this button represents.
    */
  String buttonName;
  /**
    * The cursor to use when this button is dragged.
    */
  Cursor dragCursor;

  /** Instantiate a new draggable button with the specified internal name,
    * icon, and cursor. The internal name will be wrapped in a
    * {@link Transferable}, and a drop target can subsequently use the
    * <CODE>getComponent</CODE> factory methods in <CODE>Elements</CODE>
    * to retrieve a new instance of the associated circuit component.
    *
    * @param name      the name used internally within the simulator to refer
    *                  to particular types of circuit components. 
    * @param myIcon    the icon displayed on this button.
    * @param myCursor  the drag cursor associated with this button.
    */
  public DragButton(String name, ImageIcon myIcon, Image myCursor) {
    super(myIcon);
    buttonName = name;
    dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(
                          myCursor, new Point(16, 12), buttonName);
    DragSource dragSource = DragSource.getDefaultDragSource();
    dragSource.createDefaultDragGestureRecognizer(
                          this, DnDConstants.ACTION_COPY_OR_MOVE, this);
  }

  /**
    * Initiate a drag with the appropriate cursor and a transferable
    * wrapping the appropriate internal name.
    */
  public void dragGestureRecognized(DragGestureEvent e) {
    e.startDrag(dragCursor, new StringSelection(buttonName), this);
  }
  
  public void dragDropEnd(DragSourceDropEvent e) {}
  /**
    * Display the same iconic cursor over a drop target.
    */
  public void dragEnter(DragSourceDragEvent e) {
    DragSourceContext context = e.getDragSourceContext();
    context.setCursor(dragCursor);
  }
  public void dragExit(DragSourceEvent e) {}
  public void dragOver(DragSourceDragEvent e) {}
  public void dropActionChanged(DragSourceDragEvent e) {}
}
