/*  Class EmptyComponent.
    Used within a network to designate unoccupied nodes (those w/o horizontal shorts).

    Created by: Mike Cammarano.
*/

import java.awt.*;
import java.awt.image.*;
import java.lang.String.*;
import java.net.*;
import javax.swing.*;

public class EmptyComponent implements CircuitComponent 
{
  private static ImageIcon icon;
  private static String name = "Empty";

  static {
    URL myURL = ClassLoader.getSystemResource("ToolEmpty.gif");
    icon = new ImageIcon(myURL);
  }

  public EmptyComponent() {}

  /**
    * The component occupies one rung.
    */
  public int size()
  {
    return 1;
  }

  /**
    * Returns false (no power passes through this component).
    */
  public boolean[] step(boolean[] b) {
    boolean[] a = {false};
    return a;
  }

  public void edit() {}

  /**
    * Clears any registers marked as used by this component prior to
    * its deletion.
    */
  public void clear() {}

  public void reset() {}

  public String getTip() {
    return "";
  }

  public String getName() {
    // This component does need a name, for use in save files.
    return name;
  }

  public ImageIcon getToolIcon() {
    return icon;
  }

  public CircuitComponent getInstance() {
    return new EmptyComponent();
  }

  public CircuitComponent getInstance(int[] a) {
    EmptyComponent x = new EmptyComponent();
    return x;
  }

  public String getSaveData() {
    return name;
  }

  /**
    * This component should not terminate a rung.
    */
  public boolean terminatesRung()
  {
    return false;
  }

  public Image getImage() {
  	return icon.getImage();
  }

  public void drawComponent(Graphics g, int x, int y, ImageObserver o) {
    g.drawImage(icon.getImage(), x, y, o);
  }
}