/*  Class EndRowComponent.
    Used within a network to designate unusable nodes at the end of a rung
    that has been terminated (by an output coil, for instance).
    Most of the methods are empty, since this component only serves as a
    placeholder.

    Created by: Mike Cammarano and Charlie So.
*/

import java.awt.*;
import java.awt.image.*;
import java.lang.String.*;
import javax.swing.*;

public class EndRowComponent implements CircuitComponent 
{	
  private static ImageIcon icon;
  private static String name = "EndRow";

  static {
    	icon = new ImageIcon();
  }

  public EndRowComponent() {}

  public int size()
  {
    // The component occupies one rung.
    return 1;
  }

  public boolean[] step(boolean[] b) {
    // It doesn't really matter what we return, since it's not legal
    // to put any other types of components to the right of this.
    boolean[] a = {false};
    return a;
  }

  public void edit() {}

  /**
    * Clears any registers marked as used by this component prior to
    * its deletion.
    */
  public void clear() {}

  public void reset() {}

  public String getTip() {
    return "";
  }

  public String getName() {
    // This component does need a name, for use in save files.
    return name;
  }

  public ImageIcon getToolIcon() {
    return icon;
  }

  public CircuitComponent getInstance() {
    return new EndRowComponent();
  }

  public CircuitComponent getInstance(int[] a) {
    EndRowComponent x = new EndRowComponent();
    return x;
  }

  public String getSaveData() {
    return name;
  }

  public boolean terminatesRung()
  {
    // This component marks a node that is already past the end of a rung.
    // There certainly can't be anything else after it.
    return true;
  }

  public Image getImage() {
    return icon.getImage();
  }

  public void drawComponent(Graphics g, int x, int y, ImageObserver o) {}
}
