import java.io.File;
import java.lang.*;
import javax.swing.filechooser.*;

/**
  * <CODE>ExtensionFileFilter</CODE> is a very simple implementation of
  * <CODE>JFileChooser.FileFilter</CODE>. It filters only files with a
  * specific extension.
  *
  * @author Mike Cammarano
  * @author Charlie So
  */
public class ExtensionFilter extends FileFilter
{
   /**
     * The file extension to permit.
     */
   private String extension;
   /**
     * The string description for this filter shown in the file chooser.
     */
   private String description;

   /**
     * Constructs a new <CODE>ExtensionFilter</CODE>.
     *
     * @param ext  the file extension to filter on, such as "gif".
     * @param desc the string description for this filter.
     */
   public ExtensionFilter(String ext, String desc) {
     extension = ext;
     description = desc;
   }

   /**
     * Tests whether or not a given file passes the filter
     *
     * @param f  the file to test.
     *
     * @return   <CODE>True</CODE> if the file should be displayed.
     */
   public boolean accept(File f) {
     if(f.isDirectory())
       return true;
     String s = f.getName();
     return (s.endsWith("." + extension));
   }

   /**
     * Returns the description of this filter to be shown in the file chooser.
     *
     * @return   the string description.
     */
   public String getDescription() {
     return description;
   }
}
