import java.awt.*;
import java.awt.event.*;
import java.lang.String.*;
import javax.swing.*;
import javax.swing.border.*;

/**
  * Dialog box for switches.
  * This modal Dialog allows the user to specify one bit from any memory
  * line (input, momentary, output, flag, or any register) to use as its input.
  *
  * @author Mike Cammarano
  * @author Charlie So
  */
public class NONCDialog extends JDialog implements ActionListener
{
  private ButtonGroup rbg;

  private JRadioButton momentaryButton;
  private JComboBox    momentaryCombo;
  private JRadioButton inputButton;
  private JComboBox    inputCombo;
  private JRadioButton outputButton;
  private JComboBox    outputCombo;
  private JRadioButton flagButton;
  private JComboBox    flagCombo;
  private JRadioButton regButton;
  private JComboBox    regCombo;
  private JComboBox    bitCombo;

  private int line, bit;

  /**
    * Construct a new instance of the dialog.
    */
  public NONCDialog(Frame o) {
    	super(o, "Inputs", true);

      JPanel p1,p2,p3,p4;

    	rbg = new ButtonGroup();
      ButtonModel bm;

    	getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

    	JPanel mainPane = new JPanel();
	mainPane.setLayout(new GridLayout(1,2));
      JPanel left = new JPanel();
      JPanel right = new JPanel();
      p1 = new JPanel();
	p1.setLayout(new GridLayout(2,1));
      p2 = new JPanel(); 
	p2.setLayout(new GridLayout(2,1));
      p3 = new JPanel();
	p3.setLayout(new GridLayout(2,1));
      p4 = new JPanel(); 
	p4.setLayout(new GridLayout(2,1));
      momentaryButton = new JRadioButton((new String("Momentary")));
      bm = momentaryButton.getModel();
      bm.setActionCommand("M");
      p1.add(momentaryButton);
      rbg.add(momentaryButton);
      momentaryCombo = new JComboBox(new NumberListModel("", 8));
      p2.add(momentaryCombo);

      inputButton = new JRadioButton((new String("Input")));
      bm = inputButton.getModel();
      bm.setActionCommand("I");
      p3.add(inputButton);
      rbg.add(inputButton);
      inputCombo = new JComboBox(new NumberListModel("", 32));
      p4.add(inputCombo);

      outputButton = new JRadioButton((new String("Output")));
      bm = outputButton.getModel();
      bm.setActionCommand("O");
      p1.add(outputButton);
      rbg.add(outputButton);
      outputCombo = new JComboBox(new NumberListModel("", 32));
      p2.add(outputCombo);
      flagButton = new JRadioButton((new String("Flag")));
      bm = flagButton.getModel();
      bm.setActionCommand("F");
      p3.add(flagButton);
      rbg.add(flagButton);
      flagCombo = new JComboBox(new NumberListModel("", 32));
      p4.add(flagCombo);
      left.add(p1);
      left.add(p2);
      right.add(p3);
      right.add(p4);
      mainPane.add(left);
      mainPane.add(right);

      getContentPane().add(mainPane);

      JPanel regPanel = new JPanel();
      regPanel.setBorder(BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(), "Register"));
      regButton = new JRadioButton();
      bm = regButton.getModel();
      bm.setActionCommand("R");
      regPanel.add(regButton);
      rbg.add(regButton);
      regCombo = new JComboBox(new NumberListModel("Reg ", 1024));
      regPanel.add(regCombo);
      bitCombo = new JComboBox(new NumberListModel("bit ", 16));
      regPanel.add(bitCombo);

      getContentPane().add(regPanel);

    //  Build button panel, containing OK and Cancel buttons.		
    JPanel buttons = new JPanel();
    JButton b;
    b = new JButton("OK");
    b.addActionListener(this);
    buttons.add(b);
    b = new JButton("Cancel");
    b.addActionListener(this);
    buttons.add(b);

    getContentPane().add(buttons);
    pack();
    setResizable(false);
  }

  /**
    * Process events on the OK and Cancel buttons.
    *
    * @see ActionListener
    */
  public void actionPerformed (ActionEvent e) 
  {
    String s = e.getActionCommand();
    if(s.equals("OK")) {
      updateData();
    }
    setVisible(false);
  }

  /**
    * Prior to showing this Dialog, the setState function is called to set
    * all of the radio button and combo box selections to correspond to the
    * current settings of the component being edited.
    *
    * @param newline  initially selected memory line.
    * @param newbit   initially selected bit.
    */
  public void setState(int newline, int newbit) {
    line = newline;
    bit = newbit;
    momentaryCombo.setSelectedIndex(0);
    inputCombo.setSelectedIndex(0);
    outputCombo.setSelectedIndex(0);
    flagCombo.setSelectedIndex(0);
    regCombo.setSelectedIndex(0);
    bitCombo.setSelectedIndex(0);
    if(line == SimMemory.MOMENTARY) {
      rbg.setSelected(momentaryButton.getModel(), true);
      momentaryCombo.setSelectedIndex(bit);
    } else if(line == SimMemory.INPUT) {
      rbg.setSelected(inputButton.getModel(), true);
      inputCombo.setSelectedIndex(bit);
    } else if(line == SimMemory.OUTPUT) {
      rbg.setSelected(outputButton.getModel(), true);
      outputCombo.setSelectedIndex(bit);
    } else if(line == SimMemory.FLAG) {
      rbg.setSelected(flagButton.getModel(), true);
      flagCombo.setSelectedIndex(bit);
    } else {          //register
      rbg.setSelected(regButton.getModel(), true);
      regCombo.setSelectedIndex(line);
      bitCombo.setSelectedIndex(bit);
    }
  }

  /**
    * Returns the memory line selected in this dialog.
    *
    * @return the memory line selected in this dialog.
    */
  public int getLine() {
    return line;
  }

  /**
    * Returns the bit selected in this dialog.
    *
    * @return the bit selected in this dialog.
    */
  public int getBit() {
    return bit;
  }

  /**
    * If the user selects the OK button, this function is called to capture
    * the states of the controls and prepare all the accessor methods to
    * return the updated values. If this function is not called (i.e. if the
    * user chooses Cancel), then the accessor methods will simply return the
    * values that were initially specified by the <CODE>setState</CODE> method.
    */
  public void updateData() {
    String s = rbg.getSelection().getActionCommand();
    if(s.equals("M")) {
      line = SimMemory.MOMENTARY;
      bit = momentaryCombo.getSelectedIndex();
    } else if(s.equals("I")) {
      line = SimMemory.INPUT;
      bit = inputCombo.getSelectedIndex();
    } else if(s.equals("O")) {
      line = SimMemory.OUTPUT;
      bit = outputCombo.getSelectedIndex();
    } else if(s.equals("F")) {
      line = SimMemory.FLAG;
      bit = flagCombo.getSelectedIndex();
    } else {  // register
      line = regCombo.getSelectedIndex();
      bit = bitCombo.getSelectedIndex();
    }
  }
}
