import java.lang.*;
import java.awt.*;
import javax.swing.*;

/**
  * An instance of <Code>NetworkFrame</Code> is a container that holds an
  * instance of <Code>Network</Code>.
  *
  * @author Mike Cammarano
  * @author Charlie So
  */

public class NetworkFrame extends JInternalFrame
{
  /**
   * The number that is associated with <Code>Network</Code>.  This is used to
   * keep track of each <Code>Network</Code>.
   */
  private int myNum;
  /**
   * This is the name of the <Code>Network</Code>. This is user defined name
   * that is used when rendering the <Code>Network</Code>.
   */
  private String myName;
  /**
   * Since <Code>Network</Code> is a JPanel, we basically create a
   * JPanel to be used in the frame.
   */
  private Network MainArea;
  /**
   * This is an area on the frame that keeps track of any comments
   * the user might have to add to the <Code>Network</Code>.
   */
  private JTextArea comment;
  /**
   * This is a variable that tells whether the <Code>NetworkFrame</Code>
   * should be visible or not.
   */
  private boolean open;


  /**
   * Main constructor for <Code>NetworkFrame</Code>.
   *
   * @param   num  number associated with the current <Code>Network</Code>
   * @param   name  name associated with the current <Code>Network</Code>
   */
  public NetworkFrame(int num, String name) {
    super("Network " + num + " - " + name, false, false);
    myName = name;
    myNum = num;

    JPanel main = new JPanel();
    main.setLayout(new BoxLayout(main, BoxLayout.Y_AXIS));
    MainArea = new Network();
    main.add(MainArea);
    comment = new JTextArea(4, 40);
    comment.setLineWrap(true);
    comment.setWrapStyleWord(true);
    JScrollPane sc = new JScrollPane(comment);
    sc.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 3));
    main.add(sc);
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(main, BorderLayout.CENTER);
    open = false;
    setDefaultCloseOperation(JInternalFrame.DO_NOTHING_ON_CLOSE);
    addInternalFrameListener(Master.netList);
    pack();
    setSize(478, 325);
  }

  /**
   * Returns the panel that holds the current <Code>Network</Code>.
   *
   * @return     a <Code>Network</Code> panel with all the relevant 
   *             information.
   */
  public Network getNetwork() { return MainArea; }

  /**
   * Sets the name for the current <Code>Network</Code>, with only
   * the network number associated with the <Code>Network</Code>.
   *
   * @param   num  number associated with the current <Code>Network</Code>
   */
  public void setName(int num) {
    myNum = num;
    setTitle("Network " + num + " - " + myName);
  }

  /**
   * Sets the name for the current <Code>Network</Code>, with the new name.
   *
   * @param   name  a string that is the name of the network.
   */
  public void setName(String name) {
    myName = name;
    setTitle("Network " + myNum + " - " + myName);
  }


  /**
   * Sets the name for the current <Code>Network</Code>, with the new name
   * and a number.
   *
   * @param   num  number associated with the <Code>Network</Code>
   * @param   name  name associated with the <Code>Network</Code>
   */
  public void setName(int num, String name) {
    myName = name;
    myNum = num;
    setTitle("Network " + num + " - " + name);
  }


  /**
   * Returns the name of the current <Code>Network</Code>
   *
   * @return     a string that is the name of the current <Code>Network</Code>
   */
  public String getName() {
    return myName;
  }


  /**
   * Used to return the comments to the saving function in the <Code>Master</Code>
   * class. This returns all the comments from the current <Code>Network</Code>
   *
   * @return     a string that is the comment for the current <Code>Network</Code>
   */
  public String getText() {
    return comment.getText();
  }


  /**
   * Used to put the comments back into the <Code>Network</Code>.
   *
   * @param   s  is a string that will be written out as the comment
   *             for the current <Code>Network</Code>.
   */
  public void setText(String s) {
    comment.setText(s);
  }


  /**
   * Checks to see if the current <Code>NetworkFrame</Code> is open or visible.
   *
   * @return     a boolean open.
   */
  public boolean isOpen() {
    return open;
  }


  /**
   * To make the current <Code>NetworkFrame</Code> visible or not.
   *
   * @param   b  true to show the <Code>NetworkFrame</Code> 
   *             false to hide the <Code>NetworkFrame</Code>
   */
  public void setVisible(boolean b){
    open = b;
    super.setVisible(b);
  }
}