/*  Class NullComponent.
    Used within a network to designate nodes at the bottom of a component
    that spans multiple rungs, such as a timer.
    Most of the methods are empty, since this component only serves as a
    placeholder.

    Created by: Mike Cammarano and Charlie So.
*/

import java.awt.*;
import java.awt.image.*;
import java.lang.String.*;
import javax.swing.*;

public class NullComponent implements CircuitComponent 
{
  private static ImageIcon icon;
  private static String name = "Null";

  static {
    	icon = new ImageIcon();
  }

  public NullComponent() {}

  public int size()
  {
    // The component occupies one rung.
    return 0;
  }

  public boolean[] step(boolean[] b) {
    // It doesn't really matter what we return, since step should
    // never be called for this component.
    boolean[] a = {false};
    return a;
  }

  public void edit() {}

  /**
    * Clears any registers marked as used by this component prior to
    * its deletion.
    */
  public void clear() {}

  public void reset() {}

  public String getTip() {
    return "";
  }

  public String getName() {
    // This component does need a name, for use in save files.
    return name;
  }

  public ImageIcon getToolIcon() {
    return icon;
  }

  public CircuitComponent getInstance() {
    return new NullComponent();
  }

  public CircuitComponent getInstance(int[] a) {
    NullComponent x = new NullComponent();
    return x;
  }

  public String getSaveData() {
    return name;
  }

  public boolean terminatesRung()
  {
    // This component should not terminate a rung.
    return false;
  }

  public Image getImage() {
  	return icon.getImage();
  }

  public void drawComponent(Graphics g, int x, int y, ImageObserver o) {}
}