import java.lang.*;
import javax.swing.*;

/**
  * An implementation of <CODE>ListModel</CODE> (for a <CODE>JList</CODE>) that
  * provides a list of integers 0 through n-1.
  * Used for combo boxes with lots of numeric choices.
  *
  * @author Mike Cammarano
  * @author Charlie So
  */
public class NumberListModel extends AbstractListModel
                             implements ComboBoxModel
{
  /**
    * The prefix shown before all the numbers in this list.
    */
  private String head;
  /**
    * The number of elements in this list.
    */
  private int size;
  /**
    * The selected index in this list (for combo boxes).
    */
  private int selection;

  /**
    * Creates a new number list model with the specified prefix and range.
    *
    * @param name  the string prefixed to all numbers in the list.
    * @param max   the largest number plus one.
    */
  NumberListModel(String name, int max) {
     head = name;
     size = max;
  }

  /**
    * Retrieves the string to show for the specified index.
    *
    * @param index  the index in the list.
    *
    * @return       the string to display.
    */
  public Object getElementAt(int index) {
     return head + index;
  }

  /**
    * Returns the number of elements in the list.
    *
    * @return  the number of elements in the list.
    */
  public int getSize() {
     return size;
  }

  /**
    * Returns the selected string (number appended to the list's prefix).
    *
    * @return  the selected string.
    */
  public Object getSelectedItem() {
    return head + selection;
  }

  /**
    * Sets the selected item.
    *
    * @param item  a string in the form <I>prefix number</I>.
    */
  public void setSelectedItem(Object item) {
    selection = Integer.parseInt(((String) item).substring(head.length()));
    fireContentsChanged(this, -1, -1);
  }
}
