/*  Class PrintingDialog.
    A window with a progress bar to display during printing. Called from Master.
    The JProgressBar, bar, is public, and is updated directly by the printing
    routines.

    Created by: Mike Cammarano and Charlie So.
*/

import java.awt.*;
import java.lang.*;
import java.net.*;
import javax.swing.*;

public class PrintingDialog extends JDialog
{
  public JProgressBar bar;

  public PrintingDialog(Frame f, int pages) {
    super(f, "Printing", true);
    setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
    getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
    URL myURL = ClassLoader.getSystemResource("print.gif");
    JLabel print = new JLabel("Printing", new ImageIcon(myURL), SwingConstants.RIGHT);
    getContentPane().add(print);
    bar = new JProgressBar(0, pages);
    bar.setStringPainted(true);
    bar.setBorder(BorderFactory.createTitledBorder(
            BorderFactory.createEtchedBorder(), "Print progress"));
    getContentPane().add(bar);
    pack();
    setSize(new Dimension(300, 150));
    setLocation(300,300);
  }
}