import java.awt.*;
import javax.swing.*;

/**
  * A plugin simulation front end that just shows a traffic light controlled
  * by OP0, OP1, and OP2. This is just a simple showcase for the simulator plugin
  * capabilities.
  */
public class TrafficPlugin extends SimulatorPlugin
{
  /**
    * The illumination state of the red light.
    */
  private boolean red;
  /**
    * The illumination state of the yellow light.
    */
  private boolean yellow;
  /**
    * The illumination state of the green light.
    */
  private boolean green;

  public TrafficPlugin() {
    setMinimumSize(new Dimension(100, 180));
    setPreferredSize(new Dimension(100, 180));
  }

  /**
    * Returns the string to use for this plugin's title bar.
    */
  public String getTitle() {
    return "Traffic Light";
  }

  /**
    * Updates this plug-in's display based on current values in <CODE>SimMemory</CODE>,
    * then modifies <CODE>SimMemory</CODE> to reflect any input.
    */
  public void step() {
    red = SimMemory.GetBit(SimMemory.OUTPUT, 0);
    yellow = SimMemory.GetBit(SimMemory.OUTPUT, 1);
    green = SimMemory.GetBit(SimMemory.OUTPUT, 2);
    repaint(100);
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    g.setColor(Color.orange);
    g.fillRoundRect(30, 10, 60, 160, 40, 40);
    g.setColor(Color.black);
    g.drawRoundRect(30, 10, 60, 160, 40, 40);
    g.setFont(Network.bigFont);
    for(int i=0; i<3; i++)
      g.drawString("OP"+i, 8, 43+50*i);
    g.setColor(red ? Color.red : Color.black);
    g.fillOval(40, 20, 40, 40);
    g.setColor(yellow ? Color.yellow : Color.black);
    g.fillOval(40, 70, 40, 40);
    g.setColor(green ? Color.green : Color.black);
    g.fillOval(40,120, 40, 40);
  }
}
