import java.awt.*;
import java.awt.image.*;
import java.lang.String.*;
import java.net.*;
import javax.swing.*;

/**
  * The unknown <CODE>CircuitComponent</CODE> is used as a placeholder when a
  * simulator file specifies a <CODE>CircuitComponent</CODE> that isn't in the
  * component bin.
  *
  * @author Mike Cammarano
  */

public class UnknownComponent implements CircuitComponent 
{	
  /**
    * Image used to draw this component in a network.
    */
  private static Image     pic;
  /**
    * The simulations internal name for this component.
    */
  private static String Name = "Unknown";
  
  static {
  // This static initializer loads all the image files needed
    URL myURL = ClassLoader.getSystemResource("ToolUnknown.gif");
    ImageIcon icon = new ImageIcon(myURL);
    pic = icon.getImage();
  }


  /**
   * A simple constructor.
   */
  public UnknownComponent() {}


  /**
    * Returns 1, the number of ladder logic rungs occupied by this component.
    *
    * @return 1, the number of ladder logic rungs occupied by this component.
   */
  public int size() {
      return 1;
  }


  /**
   * The Unknown component will behave like a horizontal short.
   *
   * @param b  array containing input logic levels of the rungs
   *           occupied by this component.
   *
   * @return b  just pass the input right through, since it is a
   *            horizontal short.
   */
  public boolean[] step(boolean[] b) {
    // This is a horizontal short, so just pass the input right on through.
    return b;
  }


  /**
   * No field exists that need to be edited for the horizontal circuit
   * component.
   *
   */
  public void edit() {}


  /**
    * Clears any registers marked as used by this component prior to
    * its deletion.
    */
  public void clear() {}

  /**
    * Resets this component (no effect).
    */
  public void reset() {}


  /**
    * Returns the text to be used as a tool tip when this component
    * is placed in the component bin.
    *
    * @return the string to display.
    */
  public String getTip() {
    return "";
  }


  /**
    * Returns the name of this component to be used internally in saved files.
    *
    * @return the string to use.
    */
  public String getName() {
    return Name;
  }


  /**
    * Returns the Icon to be used for this component in the network.
    *
    * @return the icon.
    */
  public ImageIcon getToolIcon() {
    return null;
  }


  /**
   * Returns a new instance of this component created using the default constructor.
   * This method is used by the <CODE>getComponent</CODE> factory method of
   * <CODE>Elements</CODE>.
   *
   * @return the new <CODE>CircuitComponent</CODE> instance.
   */
  public CircuitComponent getInstance() {
    return new UnknownComponent();
  }


  /**
    * Returns a one line string representing the name of this component for use in
    * a save file. The string will be of the form:
    * <BR>
    * Unknown
    *
    * <P> Note, however, that it makes little sense to save a file with an unknown
    * component!
    *
    * @return the parameter string.
   */
  public String getSaveData() {
    return(Name);
  }


  /**
    * Returns a new instance of this component, using the specified initial parameters.
    * This method is used by the <CODE>getComponent</CODE> factory method of
    * <CODE>Elements</CODE> to instantiate new components during a file open.
    *
    * @param   a  
    * @return     
    */
  public CircuitComponent getInstance(int[] a){
    UnknownComponent x = new UnknownComponent();
    return x;
  }


  /**
    * Returns whether this component must be the rightmost component on any rung.
    * For example, an output coil terminates a rung; a switch does not.
    *
    * @return <CODE>False</CODE> since horizontal shorts don't terminate rungs.
    */
  public boolean terminatesRung()
  {
    // This component doesn't terminate a rung.
    return false;
  }


  /**
   * Returns the image to use in the network interface.
   *
   * @return   image to be used in the rungs.
   */
  public Image getImage() {
    return pic;
  }


  /**
   * Draws this unknown component on the rung.
   *
   * @param g  the graphics context in which to draw.
   * @param x  the x-coordinate of the northwest corner.
   * @param y  the y-coordinate of the northwest corner.
   * @param o  the image observer to be notified of image drawing.
   */
  public void drawComponent(Graphics g, int x, int y, ImageObserver o) {
    g.drawImage(pic, x, y, o);
  }
}