/* plugin.c - a simple XFracky plugin
 * Henrik Wann Jensen - 01.12.97
 *
 * Compile with
 *	gcc -shared -nostdlib -O2 plugin.c -o plugin.so
 * to produce a shared library 'plugin.so' that can be
 * loaded by XFracky
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "xfracky.h"

void _init() {
register_fractal( "bug_brot", "buggy mandelbrot" );
}

static unsigned short max_iter;
static double imbug;

/*************************************************/
float bug_brot( const double x, const double y ) {
/*************************************************/
  double r, rc, im, imc, im2, r2;
  unsigned short iter=1;

  r  = rc = x;
  im = imc = y;
  imc *= imbug; /* modify imc to obtain bug effect */
  im2 = im*im;
  r2 = r*r;

  /* the usual mandelbrot loop */
  while (++iter<max_iter && (r2+im2)<4.0) {
    im *= r;
    im += im + imc;
    r = r2-im2 + rc;
    r2 = r*r;
    im2 = im*im;
  }

  return (float)iter/(float)max_iter;
}


/***************************/
bug_brot_init( xf_parm *xp )
/***************************/
{
  imbug = atof(tcl_get_var("bug_brot_imbug"));
  max_iter = xp->max_iter;
}


/***********************/
void bug_brot_exit(void)
/***********************/
{
  /* could do some exit stuff here... */
}


char *bug_brot_tcl =
"global bug_brot_imbug\n"
"proc bug_brot_tcl { w } {\n"
"  global bug_brot_imbug\n"
"  set bug_brot_imbug 0.9\n"
"  label $w.title -text \"bug brot parameter\"\n"
"  pack $w.title -side top -fill x\n"
"  frame $w.x\n"
"  label $w.x.txt -text \"im-bug\"\n"
"  entry $w.x.inp -relief sunken -textvariable bug_brot_imbug -width 12\n"
"  pack $w.x.txt -side top -fill both\n"
"  pack $w.x.inp -side bottom -fill both -expand true\n"
"  pack $w.x -side left -fill both -expand true -padx 10\n"
"  focus $w.x.inp\n"
"  }";

