/* simple.c - a very simple XFracky plugin
 * Henrik Wann Jensen - 01.12.97
 *
 * Compile with
 *	gcc -shared -nostdlib -O2 simple.c -o simple.so
 * to produce a shared library 'simple.so' that can be
 * loaded by XFracky
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "xfracky.h"

void _init() {
register_fractal( "mandel", "mandelbrot" );
}

static unsigned short max_iter;

/*************************************************/
float mandel( const double x, const double y ) {
/*************************************************/
  double r, rc, im, imc, im2, r2;
  unsigned short iter=1;

  r  = rc = x;
  im = imc = y;
  im2 = im*im;
  r2 = r*r;

  /* the usual mandelbrot loop */
  while (++iter<max_iter && (r2+im2)<4.0) {
    im *= r;
    im += im + imc;
    r = r2-im2 + rc;
    r2 = r*r;
    im2 = im*im;
  }

  return (float)iter/(float)max_iter;
}


/***************************/
mandel_init( xf_parm *xp )
/***************************/
{
  max_iter = xp->max_iter;
}


