/* xfracky.h          - data-structures for xfracky plug-ins
 * Henrik Wann Jensen - 29.11.97
 */
#ifndef XFRACKY_H
#define XFRACKY_H

typedef struct {
  double left_real;        /* left real value */
  double right_real;       /* right real value */
  double upper_imag;       /* upper imaginary value */
  double lower_imag;       /* lower imaginary value */
  unsigned int max_iter;   /* max. number of iterations */
  unsigned short width;    /* width of picture */
  unsigned short height;   /* height of picture */
  double time;             /* time (if animated) */
} xf_parm;

#ifdef __cplusplus
extern "C" {
#endif
  int register_fractal( const char *basename, const char *menuname );
  char *tcl_get_var( char *var);
#ifdef __cplusplus
  };
#endif

#endif
