//############################################################
// DepthMap.cc
// Kari Pulli
// 3/5/96
//############################################################

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <math.h>
#include <limits.h>
#include "DepthMap.h"

#define SHOW(x) cout << #x " = " << x << endl;

DepthMap::DepthMap(int w, int h)
: m_height(h), m_width(w), m_size(h*w)
{
  index = new int[m_size];
  for (int i=0; i<m_size; i++) index[i] = BAD;
}

DepthMap::~DepthMap()
{
  delete[] index;
}


// put the points in the list xyz, store
// the indices to a m_width*height list
int
DepthMap::read(const char *file, Format format)
{
  int i,j,k;
  ifstream from(file);

  if (!from) {
    cerr << "Cannot open inputfile " << file << '\n';
    return 0;
  }

  if (format == RAWRLE) {
    int idx[2];
    // check the dimensions
    from.read((char *)&idx, 2*sizeof(int));
    assert(idx[0] == m_width);
    assert(idx[1] == m_height);
    i=0;
    // figure out goods and bads
    int cnt = 0;
    while (1) {
      from.read((char *)&idx, 2*sizeof(int));
      if (idx[0] == -1) {
	while (i<m_size) index[i++] = BAD;
	break;
      }
      while (i<idx[0])        index[i++] = BAD;
      while (i<idx[0]+idx[1]) index[i++] = cnt++;
    }
    // read in the data for goods
    //    xyz.resize(cnt);
    if (xyz.size() < cnt) 
      xyz.insert(xyz.end(), cnt-xyz.size(), Pnt3());
    from.read(xyz[0], cnt*3*sizeof(float));
  } else if (format == RAW) {
    float *x = new float[m_size];
    float *y = new float[m_size];
    float *z = new float[m_size];
    
    // read data
    for (i=m_height-1; i>=0; i--) {
      from.read((char *)&x[i*m_width], 4*m_width);
    }
    for (i=m_height-1; i>=0; i--) {
      from.read((char *)&y[i*m_width], 4*m_width);
    }
    for (i=m_height-1; i>=0; i--) {
      from.read((char *)&z[i*m_width], 4*m_width);
    }
    
    for (i=0; i<m_height; i++) {
      for (j=0; j<m_width; j++) {
	k = i*m_width+j;
	if (x[k] == -320.0 &&
	    y[k] == -320.0 &&
	    z[k] == -320.0) {
	  // bad data
	  index[k] = BAD;
	} else if (i==0 || j==0 || i==m_height-1 || j==m_width-1){
	  // ignore boundaries
	  index[k] = BAD;
	} else {
	  if (format == RAW) {
	    index[k] = xyz.size();
	    xyz.push_back(Pnt3(x[k], y[k], z[k]));
	  }
	}
      }
    }
    delete[] x;
    delete[] y;
    delete[] z;
  } else {
    cerr << "Unrecognized format" << endl;
    return 0;
  }

  updateBoundingBox();

  return 1;
}


// parameter step can be used to subsample the points when
// saving in UW format. e.g. step 4 would give only 1/16th
// of the points
int
DepthMap::write(const char *file, Format format, int step)
{
  int i,j,ind;

  ofstream to (file);
  if (!to) {
    cerr << "Cannot open outputfile " << file << endl;
    return 0;
  }

  switch (format) {
  case RAW:
    {
      float badVal = -320;
      for (i=m_height-1; i>=0; i--) {
	for (j=0; j<m_width; j++) {
	  ind = at(j,i);
	  if (ind < 0)
	    to.write((char *)&badVal, sizeof(float));
	  else {
	    float val = xyz[at(j,i)][0];
	    to.write((char *)&val, sizeof(float));
	  }
	}
      }
      for (i=m_height-1; i>=0; i--) {
	for (j=0; j<m_width; j++) {
	  ind = at(j,i);
	  if (ind < 0)
	    to.write((char *)&badVal, sizeof(float));
	  else {
	    float val = xyz[at(j,i)][1];
	    to.write((char *)&val, sizeof(float));
	  }
	}
      }
      for (i=m_height-1; i>=0; i--) {
	for (j=0; j<m_width; j++) {
	  ind = at(j,i);
	  if (ind < 0)
	    to.write((char *)&badVal, sizeof(float));
	  else {
	    float val = xyz[at(j,i)][2];
	    to.write((char *)&val, sizeof(float));
	  }
	}
      }
    }
    break;
  case RAWRLE:
    // format: first write the size of the image
    // the origin is low left corner
    // then write index for the good data, and runlength
    // repeat this for the whole image
    // store -1,-1 to tell this part's done
    // then store the actual data: x y z, x y z, ...
    {
      // write the image size
      to.write((char *)&m_width,  sizeof(int));
      to.write((char *)&m_height, sizeof(int));
      // find the strips of good data
      int idx;
      int bads = 1;
      int cnt = 0;
      for (i=0; i<m_size; i++) {
	if        ( bads && !good(i)) {
	  continue;
	} else if ( bads && good(i)) {
	  bads = 0; idx = i; cnt = 1;
	} else if (!bads && good(i)) {
	  cnt++;
	} else if (!bads && !good(i)) {
	  to.write((char *)&idx, sizeof(int));
	  to.write((char *)&cnt, sizeof(int));
	  bads = 1;
	}
      }
      if (!bads) {
	to.write((char *)&idx, sizeof(int));
	to.write((char *)&cnt, sizeof(int));
      }
      // write the marker: end of run length stuff
      idx = -1;
      to.write((char *)&idx, sizeof(int));
      to.write((char *)&idx, sizeof(int));
      // write the actual data
      for (i=0; i<m_size; i++) {
	if (good(i)) to.write(xyz[index[i]], 3*sizeof(float));
      }
    }
    break;
  case UW:
    {
      cout << "Saving points in uw format" << endl;
      Pnt3 pnt;
      for (i=0; i<m_height; i+=step) {
	for (j=0; j<m_width; j+=step) {
	  ind = at(j,i);
	  if (ind != BAD) {
	    pnt = xyz[ind];
	    to << "p " << pnt[0] << " " << pnt[1] 
	      << " " << pnt[2] << endl;
	  }
	}
      }
    }
    break;
  default:
    cerr << "Unknown format" << endl;
    return 0;
  }
  to << flush;
  to.close();
  return 1;
}

void
DepthMap::updateBoundingBox()
{
  bb.clear();
  int i,j;
  for (i=0; i<m_height; i++) {
    for (j=0; j<m_width; j++) {
      int ind = at(j,i);
      if (ind >= 0) bb.add(xyz[ind]);
    }
  }
}


