//############################################################
// SimuRange.C
// Kari Pulli
// 3/5/96
// A class that uses an Inventor viewer as a range simulator
//############################################################

#include <GL/gl.h>
#include <Inventor/SbLinear.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>

#include <iostream.h>
#include <fstream.h>
#include "SimuRange.h"

SimuRange::SimuRange(int w, int h)
: m_height(h), m_width(w)
{
  m_img = new Image(w,h,3);
  m_xyz = new DepthMap(w,h);
}

SimuRange::~SimuRange(void)
{
  delete m_img;
  delete m_xyz;
}

void
SimuRange::shoot(SoXtViewer *viewer, char *name, Output )
{
  SoCamera *cam = viewer->getCamera();
  // get the viewportsize
  SbVec2s vps = 
    viewer->getViewportRegion().getViewportSizePixels();
  cout << vps[0] << " " << vps[1] << endl;
  if (vps[0]>640 || vps[1]>480) {
    cerr << "Resize the window!!" << endl;
    return;
  }
  // get the depth values
  float *zval = new float[vps[0] * vps[1]];
  glReadPixels(0,0, vps[0],vps[1], GL_DEPTH_COMPONENT,
	       GL_FLOAT, zval);
  // the depth values vary btw. 0 (near clip plane) 
  // and 1 (far clip plane)
  float nearD = cam->nearDistance.getValue();
  float farD  = cam->farDistance.getValue();
  
  float aspRat = 
    viewer->getViewportRegion().getViewportAspectRatio();

  double height, width, htan, wtan;

  // camera is either orthographic, or then perspective
  int ortho = cam->isOfType(SoOrthographicCamera::getClassTypeId());

  if (ortho) {
    height = ((SoOrthographicCamera *) cam)->height.getValue();
    width  = height * aspRat;
//    cout << "w x h " << width << " " << height << endl;
  } else {
    htan = tan(((SoPerspectiveCamera *)
		cam)->heightAngle.getValue()/2.0);
    wtan = htan*aspRat;
  }
  
  char fname[256];
  strcpy(fname, name); strcat(fname, ".m");
  ofstream to(fname);
  Pnt3 p;

  glReadBuffer(GL_FRONT);

  double midw = vps[0]/2.0 - .5;
  double midh = vps[1]/2.0 - .5;
  
  int step = 1;
  for (int i=0; i<vps[1]; i+=step) {
    // read a row's worth of image
    glReadPixels(0, i, vps[0], 1, GL_RGB, GL_UNSIGNED_BYTE, 
		 m_img->getValues(0,i));
    for (int j=0; j<vps[0]; j+=step) {
      if (zval[j+i*vps[0]] < 1.0) {
	// not a background pixel
	if (ortho) {
	  p = Pnt3((width*(j-midw)) /vps[0],
		   (height*(i-midh))/vps[1],
		   -nearD-zval[j+i*vps[0]]*(farD-nearD));
	} else {
	  double z = 2.0*zval[j+i*vps[0]]-1.0;
	  p = Pnt3(wtan*(j-midw)/midw,
		   htan*(i-midh)/midh,
		   -1);
	  double fact = 2.0*farD*nearD/
	    (farD+nearD - (farD-nearD)*z);
	  p *= fact;
	}
	to << "p " << p[0] << " " << p[1] << " " << p[2] << endl;
	m_xyz->setPoint(j,i,p);
      }
    }
  }
  to.close();
#if 1
  strcpy(fname, name); strcat(fname, ".rlexyz");
  m_xyz->write(fname, DepthMap::RAWRLE);
  strcpy(fname, name); strcat(fname, ".rgb");
//  m_img->rgb2bw();
  m_img->write(fname, Image::SGI);
  // store the transformation matrix
  strcpy(fname, name); strcat(fname, ".xf");
  to.open(fname);
  SbMatrix rot;
  cam->orientation.getValue().getValue(rot);
  to << rot[0][0] << " " << rot[0][1] << " " << rot[0][2] <<" 0 ";
  to << rot[1][0] << " " << rot[1][1] << " " << rot[1][2] <<" 0 ";
  to << rot[2][0] << " " << rot[2][1] << " " << rot[2][2] <<" 0 ";
  to << cam->position.getValue()[0] << " ";
  to << cam->position.getValue()[1] << " ";
  to << cam->position.getValue()[2] << " 1" << endl;
  to.close();
#endif
  cout << "done" << endl;
  delete[] zval;
}

