//############################################################
// SimuRange.h
// Kari Pulli
// 3/5/96
// A class that uses an Inventor viewer as a range simulator
//############################################################

#ifndef _simurange_h_
#define _simurange_h_

#include <iostream.h>
#include "Image.h"
#include "DepthMap.h"
#include "Pnt3.h"

#include <Inventor/Xt/viewers/SoXtViewer.h>

class SimuRange {
private:
  int           m_height;
  int           m_width;
  Image        *m_img;
  DepthMap     *m_xyz;

public:

  enum Output { UW = 1, RGB = 2, XYZ = 4 };

  SimuRange(int w, int h);
  ~SimuRange();
  int height() const { return m_height; }
  int width()  const { return m_width; }

  void shoot(SoXtViewer *viewer, char *name,
	     Output = UW);
};

#endif
