//----------------------------------------------------------------
//
//  geometry.h
//
//----------------------------------------------------------------

#ifndef _geometry_h_
#define _geometry_h_

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoPointSet.h>
#include <Inventor/nodes/SoIndexedFaceSet.h>
#include <Inventor/nodes/SoIndexedTriangleStripSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoMaterialBinding.h>
#include <Inventor/actions/SoWriteAction.h>
#include <iostream.h>
#include <fstream.h>

#include "Image.h"

class Geometry {
private:
  SoSeparator       *root;
  SoMaterialBinding *mb;
  SoMaterial        *mat;
  SoCoordinate3     *coord;
  SoIndexedFaceSet  *fSet;
  SoIndexedTriangleStripSet  *tSet;
  SoPointSet        *pSet;
  int                no_colors;
  enum { NOTHING, GENERAL, POINTS, MESH } graphType;

  Image img;

  void figureOutGraphType(void);
  void initPoints(void);
  void initMesh(void);

public:
  Geometry();
  ~Geometry();
  SoSeparator *getRoot()     { return root; }
  void ignore_colors()       { no_colors = 1; }
  void readEdgeData(ifstream &from);
  int  readFile(char *);
  void writeFile(char *, int UWformat);
};

/*
class Bbox {
private:
  float v[6];
  
public:
  Bbox(void) { clear(); }
  ~Bbox(void) {}

  void clear(void)
    { v[0] = v[1] = v[2] = -1.e33; v[3] = v[4] = v[5] = 1.e33; }

  void add(float x, float y, float z)
    {
      if      (x > v[0])  v[0] = x;
      else if (x < v[3])  v[3] = x;
      if      (y > v[1])  v[1] = y;
      else if (y < v[4])  v[4] = y;
      if      (z > v[2])  v[2] = z;
      else if (z < v[5])  v[5] = z;
    }
  void add(float *a)  { add(a[0], a[1], a[2]); }

  float *min(void)    { return &v[3]; }
  float *max(void)    { return v; }
};
*/
#endif
