//############################################################
// CString.C
// Kari Pulli
// 12/8/95
// Class for string operations
// not called "String" because Motif has that type already...
//############################################################

#include "CString.h"
#include <ctype.h>
#include <stdio.h>

const CString CString::Empty;

CString::CString(size_t allocSize)
: count(allocSize)
{
  if (allocSize) {
    rep = new char[allocSize];
    rep[0] = 0;
  }
}

CString::CString(const CString &source, size_t allocSize)
{
  size_t l = source.length() + 1;
  if (allocSize > l) l = allocSize;
  rep = new char[l];
  count = l;
  strcpy(rep, source.rep);
}

CString::CString(const char *source, size_t allocSize)
{
  size_t l = strlen(source) + 1;
  if (allocSize > l) l = allocSize;
  rep = new char[l];
  count = l;
  strcpy(rep, source);
}

CString::CString(char source, size_t allocSize)
{
  size_t l = 2;
  if (allocSize > l) l = allocSize;
  rep = new char[l];
  count = l;
  rep[0] = source; rep[1] = 0;
}

CString::~CString(void)
{
  if (count) delete[] rep;
}

CString 
CString::subString(size_t position, size_t count) const
{
  if (length() > position) {
    CString ret(&rep[position]);
    ret.rep[count] = 0;
    return ret;
  } else {
    return CString();
  }
}

Boolean
CString::isBlank(void) const
{
  if (count == 0) return TRUE;
  char *tmp = rep;
  while (*tmp != 0) {
    if (!isspace(*tmp))
      return FALSE;
    tmp++;
  }
  return TRUE;
}

CString &
CString::operator =(const CString &s)
{
  int l = s.length() + 1;
  if (l > count) {
    if (count) delete[] rep;
    rep = new char[l];
    count = l;
  }
  strcpy(rep, s.rep);
  return *this;
}

CString &
CString::operator +=(const CString &s)
{
  int l = length() + s.length() + 1;
  if (l > count) {
    char *tmp = new char[l];
    tmp[0] = 0;
    if (count) {
      strcpy(tmp, rep);
      delete[] rep;
    }
    rep = tmp, count = l;
  }
  strcat(rep, s.rep);
  return *this;
}

CString &
CString::operator +(const CString &s) const
{
  CString retval(rep);
  retval += s;
  return retval;
}

CString &
CString::trim(void)
{
  int l = length()-1;
  while (isspace(rep[l]))
    rep[l--] = 0;
  l = 0;
  while (isspace(rep[l])) l++;
  strcpy(rep, &rep[l]);
  return *this;
}

int 
CString::find (const char *s, size_t position) const
{
  if (position < length()) {
    int l = strlen(s);
    while (rep[position]) {
      if (strncmp(&rep[position], s, l) == 0)
	return position;
      position++;
    }
  }
  return NOT_FOUND;
}

int 
CString::find (char c, size_t position) const
{
  if (position < length()) {
    while (rep[position]) {
      if (rep[position] == c)
	return position;
      position++;
    }
  }
  return NOT_FOUND;
}

int 
CString::rfind (const char *s, size_t position) const
{
  int last_found = NOT_FOUND;
  if (position < length()) {
    int l = strlen(s);
    while (rep[position]) {
      if (strncmp(&rep[position], s, l) == 0)
	last_found = position;
      position++;
    }
  }
  return last_found;
}

int 
CString::rfind (char c, size_t position) const
{
  int last_found = NOT_FOUND;
  if (position < length()) {
    while (rep[position]) {
      if (rep[position] == c)
	last_found = position;
      position++;
    }
  }
  return last_found;
}


CString 
ntos(long         n,
     int          width,
     const char * flag)
{
  char format[80], out[80];
  sprintf(format, "%%%s%dld", flag, width);
  sprintf(out, format, n);
  return CString(out);
}
 
CString 
ntos(double       n,
     int          width,
     int          precision,
     const char * flag)
{
  char format[80], out[80];
  sprintf(format, "%%%s%d.%dlf", flag, width, precision);
  sprintf(out, format, n);
  return CString(out);
}


istream &
operator >>(istream &is, CString &string)
{
  if (string.count < 256) {
    if (string.count) delete[] string.rep;
    string.count = 256;
    string.rep = new char[string.count];
  }
  return is.getline(string.rep, string.count);
}

ostream &
operator <<(ostream &os, const CString &string)
{
  if (string.count)
    return os << string.rep;
  else
    return os;
}
