//############################################################
// CString.h
// Kari Pulli
// 12/8/95
// Class for string operations
// not called "String" because Motif has that type already...
//############################################################

#ifndef _CSTRING_H_
#define _CSTRING_H_

#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include "Boolean.h"

class CString {
public:
  enum { NOT_FOUND = -1 };

  // constructors
  CString(size_t allocSize = 0);
  CString(const CString &source, size_t allocSize = 0);
  CString(const char    *source, size_t allocSize = 0);
  CString(char source          , size_t allocSize = 0);

  ~CString(void); 

  // casts
//  operator const char *(void) const;
  operator char *      (void) const;
  operator long        (void) const;
  operator double      (void) const;

//  char operator[](size_t n) const;
//  char &operator[](size_t n);

  size_t length(void) const;
    // returns the length of the string
  CString subString(size_t position, size_t count) const;
    // returns count long substring starting from position
  Boolean isBlank(void) const;
    // does the string consist only of white space?

  CString &operator =(const CString &s);
    // assign
  CString &operator +=(const CString &s);
    // append
  CString &operator +(const CString &s) const;
    // append, don't change this

  Boolean operator ==(const CString &s) const;

  CString &trim(void);
    // trims blank space from both ends of string

  int find (const char *s, size_t position = 0) const;
  int find (char        c, size_t position = 0) const;
  int rfind(const char *s, size_t position = 0) const;
  int rfind(char        c, size_t position = 0) const;
 
  friend CString ntos(long         n,
		      int          width     = 0,
		      const char * flag      = "");
  friend CString ntos(double       n,
		      int          width     = 0,
		      int          precision = 6,
		      const char * flag      = "");
    // number to string conversion
    // flags are standard printf flags after % and before d or f

  static const CString Empty;

  // stream IO
  friend istream &operator >>(istream &is, CString &string);
  friend ostream &operator <<(ostream &os, const CString &string);
  
private:
  char *rep;
  size_t   count;
};

//inline char 
//CString::operator[](size_t n) const
//{
//  return rep[n];
//}

//inline char &
//CString::operator[](size_t n)
//{
//  return rep[n];
//}

//inline
//CString::operator const char *(void) const
//{
//  return rep;
//}

inline
CString::operator char *(void) const
{
  return rep;
}

inline
CString::operator long(void) const
{
  return atol(rep);
}

inline
CString::operator double(void) const
{
  return atof(rep);
}

inline Boolean
CString::operator ==(const CString &s) const
{
  return (0==strcmp(rep, s.rep));
}

inline size_t
CString::length(void) const
{
  return count ? strlen(rep) : 0;
}
  

#endif
