//############################################################
// CascadeButton.C
// Kari Pulli
// 12/11/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/CascadeB.h>
}

static Widget
createButton(char *  name,
	     Widget  parent,
	     Widget  menu)
{
  Arg arg;
  XtSetArg(arg, XmNsubMenuId, menu);
  return XmCreateCascadeButton(parent, name, &arg, 1);
}

#include "CString.h"
#include "MenuBar.h"
#include "PulldownMenu.h"
#include "CascadeButton.h"

  
CascadeButton::CascadeButton(const CString       &label,
			     const PulldownMenu  &menu,
			     const MenuBar       &parent)
{
  rtr.mrep = createButton(label, (Widget) parent, 
			  (Widget) menu);
  manage();
}

CascadeButton::CascadeButton(const CString       &label,
			     const PulldownMenu  &menu,
			     const PulldownMenu  &parent)
{
  rtr.mrep = createButton(label, (Widget) parent, 
			  (Widget) menu);
}

