//############################################################
// Color.C
// Kari Pulli
// 12/08/95
// The color class for a Motif GUI library
//############################################################

#include "Color.h"

Boolean  Color::classInit = FALSE;
Visual * Color::visual    = NULL;
int      Color::cells     = 0;
Colormap Color::cmap      = (Colormap) NULL;
ulong    Color::bgIndex   = 0;
ulong    Color::fgIndex   = 0;
CString *Color::names     = NULL;

void 
Color::classConstruct(void)
{
  GraphicalEnv::testConstruct();

  visual = XDefaultVisual(display, screen);

  XVisualInfo templ, *visualList;
  int         matched;

  templ.visualid = XVisualIDFromVisual(visual);
  visualList     = XGetVisualInfo(display,
				  VisualIDMask,
				  &templ,
				  &matched);
  if (matched == 0) {
    cerr << "Error getting X visual info, exiting." << endl;
    exit(1);
  }
  cells = visualList[0].colormap_size;
  XFree(visualList);

  if (cells < 2) cells = 2;

  names = new CString[cells];
  cmap  = DefaultColormap(display, screen);

  /*
  if (BlackPixel(display, screen) == 0) {
    fgIndex = WhitePixel(display, screen);
    names[bgIndex] = "black";
    names[fgIndex] = "white";
  } else if (WhitePixel(display, screen) == 0) {
    fgIndex = BlackPixel(display, screen);
    names[bgIndex] = "white";
    names[fgIndex] = "black";
  } else {
    fgIndex = WhitePixel(display, screen);
    bgIndex = BlackPixel(display, screen);
    names[fgIndex] = "white";
    names[bgIndex] = "black";
  }
  */
  fgIndex = 0;
  bgIndex = 1;
  names[bgIndex] = "black";
  names[fgIndex] = "white";
  
  classInit = TRUE;
}

Color::Color(const CString &cname)
: GraphicalEnv()
{
  testConstruct();
  if (cname.isBlank()) index = fgIndex;
  else                 requestColor(cname);
}

void 
Color::requestColor(const CString &cname)
{
  XColor exact, approx;
  if (XAllocNamedColor(display,
		       cmap,
		       (const char *) cname,
		       &approx,
		       &exact)) {
    index        = approx.pixel;
    names[index] = cname;
  } else {
    index        = fgIndex;
  }
}

const Color &
Color::operator =(const CString &cname)
{
  if (cname.isBlank()) index = fgIndex;
  else                 requestColor(cname);
  return *this;
}
