//############################################################
// Color.h
// Kari Pulli
// 12/08/95
// The color class for a Motif GUI library
//############################################################

#ifndef _COLOR_H_
#define _COLOR_H_

#include "GraphicalEnv.h"

class Color : public GraphicalEnv
{
  // class scoped members
  static Boolean   classInit;
  static Visual *  visual;     // visual policy for X
  static int       cells;      // # of colors for X
  static Colormap  cmap;       // available colors for X
  static ulong     bgIndex;    // background pixel
  static ulong     fgIndex;    // foreground pixel
  static CString * names;      // all color names in use

  // instance members
  ulong  index;                // index to color map

  static void classConstruct(void);

  static void testConstruct(void)
    { if (!classInit) classConstruct(); }

  void requestColor(const CString &cname);
    // request color by name from X

public:
  
  Color (const CString &cname = CString::Empty);
  Color (const Color &color) : GraphicalEnv()
    { index = color.index; }
  ~Color(void) {}

  const Color &operator =(const Color &c)
    { index = c.index; return *this; }
  const Color &operator =(const CString &cname);

  Boolean operator ==(const Color &c) const
    { return index == c.index; }
  Boolean operator ==(const CString &s) const
    { return names[index] == s; }

  const CString &name(void) const
    { return names[index]; }

  operator ulong(void) const 
    { return index; }  // impl. dependent access to system colormap index

  static const CString &defForeName(void)
    { testConstruct(); return names[fgIndex]; }
  static const CString &defBackName(void)
    { testConstruct(); return names[bgIndex]; }

  static int numColors(void)
    { testConstruct(); return cells; }
  static Colormap getColorMap(void)
    { testConstruct(); return cmap; }
  static Visual * getVisual(void)
    { testConstruct(); return visual; }
};

#endif
