//############################################################
// Context.h
// Kari Pulli
// 12/08/95
// The graphics context class for a Motif GUI library
//############################################################

#ifndef _CONTEXT_H_
#define _CONTEXT_H_

#include "GraphicalEnv.h"
#include "Color.h"

class PixelMap;

class Context : public GraphicalEnv 
{
 public:
  enum DrawFunction {
    DRAW_FUNC_CLEAR,
    DRAW_FUNC_SET,
    DRAW_FUNC_AND,
    DRAW_FUNC_NAND,
    DRAW_FUNC_COPY,
    DRAW_FUNC_NOOP,
    DRAW_FUNC_XOR,
    DRAW_FUNC_OR,
    DRAW_FUNC_NOR,
    DRAW_FUNC_INVERT
  };

  enum LineStyle {
    LINE_STYLE_SOLID,
    LINE_STYLE_DASH,
    LINE_STYLE_DOUBLE_DASH
  };

  enum FillStyle {
    FILL_SOLID,
    FILL_STIPPLE,
    FILL_STIPPLE_OPAQUE,
    FILL_TILE
  };

  // Line "widths" for drawing lines 1 pixel wide
  static const uint LW1_FAST;     // speed for precision
  static const uint LW1_PRECISE;  // precision for speed

private:
  static uint  tileWidth;   // Optimum width of tile
  static uint  tileHeight;  // Optimum height of tile
  static uint  stipWidth;   // Optimum width of stipple
  static uint  stipHeight;  // Optimum height of stipple
  
  GC    gc;    // X representation
  Color fore;  // foreground color for rendering
  Color back;  // background color for rendering

  static void classConstruct(void);

public:
  
  Context(const Color &fcolor, const Color &bcolor);
  ~Context(void);
  void setForeground(const Color &color);
  void setBackground(const Color &color);
  void toggleReverse(void);
    // flips foreground and background colors
  
  const CString &getForeName(void) const
    { return fore.name(); }
  const CString &getBackName(void) const
    { return back.name(); }

  Boolean setFunction(const DrawFunction func);
    // sets Boolean draw function used for drawing
  Boolean setLineStyle(const LineStyle ls = LINE_STYLE_SOLID);
  void    setLineWidth(const uint lw = LW1_FAST);
  Boolean setFillStyle(const FillStyle fs,
		       PixelMap *      pmap = NULL,
		       int             x    = 0,
		       int             y    = 0);

  static uint getTileHeight(void)
    { return tileHeight; } // allowed height for any tile for filling
  static uint getTileWidth(void) 
    { return tileWidth; } // allowed width for any tile for filling
  static uint getStippleHeight(void)
    { return stipHeight; } // allowed height for any stipple for filling
  static uint getStippleWidth(void)
    { return stipWidth; } // allowed width for any stipple for filling

  operator GC(void) const { return gc; }
};

#endif
