//############################################################
// CustomDialog.h
// Kari Pulli
// 12/21/95
// A class for a Motif GUI library
//############################################################

#ifndef _CUSTOMDIALOG_H_
#define _CUSTOMDIALOG_H_

#include "Dialog.h"
#include "TextButton.h"

class CString;
class Separator;
class Form;

#define NUM_BUTTONS Dialog::UNKNOWN

class CustomDialog : public Dialog {
protected:

  GraphicalObject  *controlArea;
  Separator        *separator;
  Form             *actionArea;
  TextButton       *button  [NUM_BUTTONS];
  CallbackHandler   activate[NUM_BUTTONS];
  void             *udata   [NUM_BUTTONS];

  Widget findButton(StandardButton b) const
    { return (Widget) *(button[b]); }

  friend void customButtonCB(GraphicalObject &,
			     GraphicalObject::CallbackType,
			     void *);
    // updates state of dialog when a button is pressed
    // and invokes any registered user callback handlers

  TextButton *createButton(int  buttonPos,
			   int &buttonCount);

public:

  CustomDialog(const CString          &name,
	       const GraphicalObject  *parent = NULL);

  ~CustomDialog(void);

  void customize(GraphicalObject &controlArea,
		 Boolean          createOK     = TRUE,
		 Boolean          createCancel = TRUE,
		 Boolean          createApply  = FALSE,
		 Boolean          createHelp   = FALSE);

  void setButtonLabel(StandardButton b,
		      const CString &label)
    { button[b]->setLabel(label); }

  void registerCallback(CallbackType,
			CallbackHandler,
			void *);
  void unregisterCallback(CallbackType);
};

#endif
