//############################################################
// Dialog.h
// Kari Pulli
// 12/14/95
// A class for a Motif GUI library
//############################################################

#ifndef _DIALOG_H_
#define _DIALOG_H_

extern "C" {
#include <Xm/MessageB.h>
};
#include "GraphicalObject.h"

class CString;

class Dialog : public GraphicalObject {
public:

  enum PoseType { WAIT,          // wait for user response
		  NO_WAIT };     // continue with processing
  enum PosCalc  { FROM_PARENT,   // position relative to parent
		  FROM_SCREEN }; // position is absolute
  enum PosType  { EXPLICIT,      
		  TOP_LEFT,      
		  TOP_RIGHT,     
		  CENTER,        
		  BOTTOM_LEFT,   
		  BOTTOM_RIGHT }; 
  enum StandardButton { OK,
			APPLY,
			CANCEL,
			HELP,
			UNKNOWN };
  static const char *APPLY_LABEL;
  static const char *CANCEL_LABEL;
  static const char *FILTER_LABEL;
  static const char *HELP_LABEL;
  static const char *NO_LABEL;
  static const char *OK_LABEL;
  static const char *YES_LABEL;

protected:

  typedef Widget (* CreateHook)(Widget,
				String,
				ArgList,
				Cardinal);
  
  PosCalc        posCalc;        // Position relative to ???
  PosType        posType;        // Placement for first pose
  int            dx;             // Explicit horizontal pos
  int            dy;             // Explicit vertical pos
  StandardButton lastButton;     // Most recent button activated
  Boolean        dismissed;      // Has dialog been dismissed?
  Boolean        cancelled;      // Has dialog been cancelled?
  Boolean        applied;        // Has dialog been applied?
  Boolean        dismissOnApply; // Dismiss with apply?

  friend void positionCB(Widget    w,
			 XtPointer clientd,
			 XtPointer calld);
    // calculate dialog placement before its mapped to the screen

  friend void stateCB(Widget    w,
		      XtPointer clientd,
		      XtPointer calld);
    // update dialog state based on button presses

  virtual Widget findButton(StandardButton b) const = 0;
    // get button widget

  void setSensitivity(StandardButton b, Boolean on);

  void setVisibility (StandardButton b, Boolean on);

  Dialog(CreateHook             cfn,
	 const CString         &name,
	 const GraphicalObject *parent = NULL);
public:

  virtual ~Dialog(void) {}

  virtual void pose(PoseType wait = WAIT);

  void setPosition(PosCalc calc = FROM_PARENT,
		   PosType pos  = CENTER,
		   int     x    = 0,
		   int     y    = 0);
    // for the first pose

  void sensitize   (StandardButton b) { setSensitivity(b, TRUE); }
  void desensitize (StandardButton b) { setSensitivity(b, FALSE); }

  void showButton(StandardButton b)
    { setVisibility(b, TRUE); }
  void hideButton(StandardButton b)
    { setVisibility(b, FALSE); }

  virtual void setButtonLabel(StandardButton b,
			      const CString &label);
  StandardButton getLastButton(void) const
    { return lastButton; }

  void setApplyDismiss(Boolean on)
    { dismissOnApply = on; }

  Boolean wasDismissed (void) const { return dismissed; }
  Boolean wasCancelled (void) const { return cancelled; }
  Boolean wasApplied   (void) const { return applied; }
    // what happened to dialog?
};

#define DLG_START(D) \
    (D).pose(Dialog::NO_WAIT);\
    while(!(D).wasDismissed()) GraphicalEnv::processEvent();\
    if (!(D).wasCancelled()) {\
	(D).setCursor(GraphicalObject::WATCH);

#define DLG_END(D) \
        (D).setCursor(GraphicalObject::DEFAULT);\
    } \
    (D).unmanage();

#endif
