//############################################################
// FileDialog.C
// Kari Pulli
// 12/18/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <Xm/FileSB.h>
};
#include "FileDialog.h"


FileDialog::FileDialog(const CString         &name,
		       const GraphicalObject *parent,
		       ModeType               mode,
		       const CString         &fname)
: InputDialog(XmCreateFileSelectionDialog, name, parent)
{
  hideButton(HELP);
  setButtonLabel(APPLY, FILTER_LABEL);

  switch (mode) {
  case MODE_ANY:
    break;
  case MODE_READ:
    cerr << "FileDialog MODE_READ not implemented, using MODE_ANY" << endl;
/*
    XtVaSetValues(rtr.mrep,
		  XmNfileSearchProc, fileSearchRead,
		  NULL);
*/
    break;
  case MODE_WRITE:
    cerr << "FileDialog MODE_WRITE not implemented, using MODE_ANY" << endl;
/*
    XtVaSetValues(rtr.mrep,
		  XmNfileSearchProc, fileSearchWrite,
		  NULL);
*/
    break;
  }

  if (!fname.isBlank()) FileDialog::operator =(fname);
}

/*
inline static Boolean
isReadable(const CString &fileName)
{
  return (Boolean) (access((char *)fileName, R_OK) != -1);
}

inline static Boolean
isWritable(const CString &fileName)
{
  return (Boolean) (access((char *)fileName, W_OK) != -1);
}

inline static Boolean
isDirectory(const CString &dirName)
{
  struct stat ftest;
  if (stat((char *) dirName, &ftest) == -1)
    return FALSE;
  return ((ftest.st_mode & S_IFMT) == S_IFDIR ? TRUE : FALSE);
}

static DIR *
getDirectory(XmString &mdirName,
	     CString  &dirName)
{
  char *dir;

  // get directory mask
  if (!XmStringGetLtoR(mdirName,
		       XmSTRING_DEFAULT_CHARSET,
		       &dir)) return NULL:

  // standardize directory name
  dirName = dir;
  if (dirName[dirName.length()-1] != '/')
    dirName += '/';

  XtFree(dir);
  return opendir(dirName);
}

static void
fileSearchRead(XmFileSelectionBoxWidget fs,
	       XmFileSelectionBoxCallbackStruct *cbs)
{
  CString dirName;
  DIR    *dir = getDirectory(cbs->dir, dirName);

  // check for bad directory
  if (!dir) return;

  struct dirent *ent;
  XmString names[FD_MAX_FILES];
  int      fileCount = 0;

  // loop thru files in the directory
  while (ent = readdir(dir)) {
    CString fileName(dirName + ent->d_name);
    if (!isDirectory(fileName) &&
	isReadable(fileName)) {
    }
  }
  // this function is not ready...
}
*/

void 
FileDialog::setFilter(const CString &text)
{
  XmString mtext = XmStringCreateSimple((char *)text);
  XmFileSelectionDoSearch(rtr.mrep, mtext);
  XmStringFree(mtext);
}

extern unsigned char ButtonLookup[]; // from PromptDialog.C

Widget 
FileDialog::findButton(StandardButton b) const
{
  return XmFileSelectionBoxGetChild(rtr.mrep, 
				    ButtonLookup[b]);
}


FileDialog::operator CString(void) const
{
  XmString mtext;

  XtVaGetValues(rtr.mrep, XmNdirSpec, &mtext, NULL);
  char *fname;
  if (!XmStringGetLtoR(mtext, 
		       XmSTRING_DEFAULT_CHARSET,
		       &fname))
    return CString::Empty;

  CString fileName = fname;
  XtFree(fname);
  return fileName;
}


const CString &
FileDialog::operator =(const CString &text)
{
  XmString mtext = XmStringCreateSimple((char *) text);
  XtVaSetValues(rtr.mrep, XmNdirSpec, mtext, NULL);
  XmStringFree(mtext);
  return text;
}
