//############################################################
// FileDialog.h
// Kari Pulli
// 12/18/95
// A class for a Motif GUI library
//############################################################

#ifndef _FILEDIALOG_H_
#define _FILEDIALOG_H_

#include "InputDialog.h"

class FileDialog : public InputDialog {

  Widget findButton(StandardButton b) const; 

public:

  enum ModeType {
    MODE_ANY,    // Existence check
    MODE_READ,   // Existence and read permission check
    MODE_WRITE,  // Existence, read and write permission check
  };

  FileDialog(const CString         &name,
	     const GraphicalObject *parent = NULL,
	     ModeType               mode   = MODE_ANY,
	     const CString         &fname  = CString::Empty);

  ~FileDialog(void) {}

  void setFilter(const CString &text);

  operator CString(void) const;
    // get selected file name

  const CString &operator =(const CString &text);
    // set selected file name
};

#endif
