//############################################################
// Form.C
// Kari Pulli
// 12/10/95
// A form class for a Motif GUI library
//############################################################

#include <assert.h>
#include "Form.h"
#include "CString.h"

Form::Form(const CString          &name,
	   const GraphicalObject *parent,
	   uint                   divisions,
	   uint                   hspace,
	   uint                   vspace)
: GraphicalObject() 
{
  Widget wparent = parent ? (Widget) *parent : topLevel;

  rtr.mrep = XtVaCreateWidget(name,
			      xmFormWidgetClass,
			      wparent,
			      XmNfractionBase,     divisions,
			      XmNhorizontalSpacing,hspace,
			      XmNverticalSpacing,  vspace,
			      NULL);
}

void 
Form::makeAttachment(Edge                   edge,
		     unsigned char          constraint,
		     int                    offset,
		     const GraphicalObject &gobj1,
		     const GraphicalObject *gobj2)
{
  Widget child, child2;

  child = findAttachWidget(gobj1);
  if (gobj2)
    child2 = findAttachWidget(*gobj2);
    
  assert(child && (!gobj2 || child2));
 
  char *mOffset;
  char *mAttachment;
  char *mWidget;
  char *mPos;

  switch (edge) {
  case Form::TOP:
    mAttachment  = XmNtopAttachment;
    mOffset      = XmNtopOffset;
    mWidget      = XmNtopWidget;
    mPos         = XmNtopPosition;
    break;

  case Form::LEFT:
    mAttachment  = XmNleftAttachment;
    mOffset      = XmNleftOffset;
    mWidget      = XmNleftWidget;
    mPos         = XmNleftPosition;
    break;

  case Form::BOTTOM:
    mAttachment  = XmNbottomAttachment;
    mOffset      = XmNbottomOffset;
    mWidget      = XmNbottomWidget;
    mPos         = XmNbottomPosition;
    break;

  case Form::RIGHT:
    mAttachment  = XmNrightAttachment;
    mOffset      = XmNrightOffset;
    mWidget      = XmNrightWidget;
    mPos         = XmNrightPosition;
    break;
  }

  Arg      argv[3];
  Cardinal argc = 0;

  XtSetArg(argv[argc], mAttachment, constraint); argc++;

  if (gobj2) XtSetArg(argv[argc], mWidget, child2), argc++;

  if (constraint == XmATTACH_POSITION) {
    XtSetArg(argv[argc], mPos, offset); argc++;
  } else {
    XtSetArg(argv[argc], mOffset, offset); argc++;
  }
  XtSetValues(child, argv, argc);
}

Widget
Form::findAttachWidget(const GraphicalObject &gobj) const
{
  Widget child   = (Widget) gobj;
  Widget parent  = XtParent(child);

  while (parent != topLevel) {
    if (parent == rtr.mrep) return child;
    child  = parent;
    parent = XtParent(child);
  }
  return (Widget) NULL;
}

void 
Form::attachObjects(const GraphicalObject &gobj1,
		    const GraphicalObject &gobj2,
		    Edge                   edge,
		    int                    offset)
{
  makeAttachment(edge, XmATTACH_WIDGET,
		 offset,
		 gobj1,
		 &gobj2);
}

void 
Form::alignObjects(const GraphicalObject &gobj1,
		   const GraphicalObject &gobj2,
		   Edge                   edge,
		   int                    offset)
{
  makeAttachment(edge, XmATTACH_OPPOSITE_WIDGET,
		 offset,
		 gobj1,
		 &gobj2);
}

void 
Form::attachForm(const GraphicalObject &gobj,
		 Edge                   edge,
		 int                    offset)
{
  makeAttachment(edge, XmATTACH_FORM,
		 offset,
		 gobj);
}

void 
Form::attachPosition(const GraphicalObject &gobj,
		     Edge                   edge,
		     int                    position)
{
  makeAttachment(edge, XmATTACH_POSITION,
		 position,
		 gobj);
}

